/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonLine;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S1720")
public class MissingDocstringCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_NO_DOCSTRING = "Add a docstring to this %s.";
    private static final String MESSAGE_EMPTY_DOCSTRING = "The docstring for this %s should not be empty.";
    private static final String EMPTY_DOCSTRING = "\"\"\" doc \"\"\"";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> MissingDocstringCheck.checkFileInput(ctx, (FileInput)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> MissingDocstringCheck.checkDocString(ctx, ((FunctionDef)ctx.syntaxNode()).docstring()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> MissingDocstringCheck.checkDocString(ctx, ((ClassDef)ctx.syntaxNode()).docstring()));
    }

    private static void checkFileInput(SubscriptionContext ctx, FileInput fileInput) {
        if ("__init__.py".equals(ctx.pythonFile().fileName()) && fileInput.statements() == null) {
            return;
        }
        MissingDocstringCheck.checkDocString(ctx, fileInput.docstring());
    }

    private static void checkDocString(SubscriptionContext ctx, @CheckForNull StringLiteral docstring) {
        Tree tree = ctx.syntaxNode();
        DeclarationType type = MissingDocstringCheck.getType(tree);
        if (docstring == null) {
            MissingDocstringCheck.raiseIssueNoDocstring(tree, type, ctx);
        } else if (docstring.trimmedQuotesValue().isBlank()) {
            MissingDocstringCheck.raiseIssue(tree, MESSAGE_EMPTY_DOCSTRING, type, ctx);
        }
    }

    private static DeclarationType getType(Tree tree) {
        if (tree.is(Tree.Kind.FUNCDEF)) {
            if (((FunctionDef)tree).isMethodDefinition()) {
                return DeclarationType.METHOD;
            }
            return DeclarationType.FUNCTION;
        }
        if (tree.is(Tree.Kind.CLASSDEF)) {
            return DeclarationType.CLASS;
        }
        return DeclarationType.MODULE;
    }

    private static void raiseIssueNoDocstring(Tree tree, DeclarationType type, SubscriptionContext ctx) {
        if (type != DeclarationType.METHOD) {
            MissingDocstringCheck.raiseIssue(tree, MESSAGE_NO_DOCSTRING, type, ctx);
        }
    }

    private static void raiseIssue(Tree tree, String message, DeclarationType type, SubscriptionContext ctx) {
        String finalMessage = String.format(message, type.value);
        PythonCheck.PreciseIssue issue = type != DeclarationType.MODULE ? ctx.addIssue(MissingDocstringCheck.getNameNode(tree), finalMessage) : ctx.addFileIssue(finalMessage);
        MissingDocstringCheck.addQuickFix(issue, tree, type);
    }

    private static Name getNameNode(Tree tree) {
        if (tree.is(Tree.Kind.FUNCDEF)) {
            return ((FunctionDef)tree).name();
        }
        return ((ClassDef)tree).name();
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, Tree tree, DeclarationType type) {
        PythonQuickFix.Builder quickFix = PythonQuickFix.newQuickFix("Add docstring");
        if (type == DeclarationType.MODULE) {
            quickFix.addTextEdit(TextEditUtils.insertAtPosition(new PythonLine(1), 0, EMPTY_DOCSTRING));
        } else if (type == DeclarationType.CLASS) {
            ClassDef classDef = (ClassDef)tree;
            quickFix.addTextEdit(TextEditUtils.insertLineAfter(classDef.colon(), classDef.body(), EMPTY_DOCSTRING));
        } else {
            FunctionDef functionDef = (FunctionDef)tree;
            quickFix.addTextEdit(TextEditUtils.insertLineAfter(functionDef.colon(), functionDef.body(), EMPTY_DOCSTRING));
        }
        issue.addQuickFix(quickFix.build());
    }

    private static enum DeclarationType {
        MODULE("module"),
        CLASS("class"),
        METHOD("method"),
        FUNCTION("function");

        private final String value;

        private DeclarationType(String value) {
            this.value = value;
        }
    }
}

