/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.IterationOnNonIterable;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.types.InferredTypes;

@Rule(key="S3862")
public class IterationOnNonIterableCheck
extends IterationOnNonIterable {
    private static final String MESSAGE = "Replace this expression with an iterable object.";

    @Override
    boolean isValidIterable(Expression expression, Map<LocationInFile, String> secondaries) {
        InferredType type;
        String typeName;
        HasSymbol hasSymbol;
        Symbol symbol;
        CallExpression callExpression;
        Symbol calleeSymbol;
        if (expression.is(Tree.Kind.CALL_EXPR) && (calleeSymbol = (callExpression = (CallExpression)expression).calleeSymbol()) != null && calleeSymbol.is(Symbol.Kind.FUNCTION) && ((FunctionSymbol)calleeSymbol).isAsynchronous()) {
            FunctionSymbol functionSymbol = (FunctionSymbol)calleeSymbol;
            secondaries.put(functionSymbol.definitionLocation(), String.format("Definition of \"%s\".", functionSymbol.name()));
            return false;
        }
        if (expression instanceof HasSymbol && (symbol = (hasSymbol = (HasSymbol)((Object)expression)).symbol()) != null) {
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
                secondaries.put(functionSymbol.definitionLocation(), String.format("Definition of \"%s\".", functionSymbol.name()));
                return functionSymbol.hasDecorators();
            }
            if (symbol.is(Symbol.Kind.CLASS)) {
                ClassSymbolImpl classSymbol = (ClassSymbolImpl)symbol;
                secondaries.put(classSymbol.definitionLocation(), String.format("Definition of \"%s\".", classSymbol.name()));
                return classSymbol.hasSuperClassWithUnknownMetaClass() || classSymbol.hasUnresolvedTypeHierarchy();
            }
        }
        String secondaryMessage = (typeName = InferredTypes.typeName(type = expression.type())) != null ? String.format("Definition of \"%s\".", typeName) : "Type definition.";
        secondaries.put(InferredTypes.typeClassLocation(type), secondaryMessage);
        return type.canHaveMember("__iter__") || type.canHaveMember("__getitem__");
    }

    @Override
    boolean isAsyncIterable(Expression expression) {
        CallExpression callExpression;
        Symbol calleeSymbol;
        if (expression.is(Tree.Kind.CALL_EXPR) && (calleeSymbol = (callExpression = (CallExpression)expression).calleeSymbol()) != null && calleeSymbol.is(Symbol.Kind.FUNCTION)) {
            return ((FunctionSymbol)calleeSymbol).isAsynchronous();
        }
        return expression.type().canHaveMember("__aiter__");
    }

    @Override
    String message(Expression expression, boolean isForLoop) {
        return isForLoop && this.isAsyncIterable(expression) ? "Add \"async\" before \"for\"; This expression is an async generator." : MESSAGE;
    }
}

