/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7501")
public class InputInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_TO_THREAD = "Wrap this call to input() with await %s.to_thread(input).";
    private static final String MESSAGE_TO_THREAD_RUN_SYNC = "Wrap this call to input() with await %s.to_thread.run_sync(input).";
    private static final String MESSAGE_FALLBACK = "Wrap this call to input() with the appropriate function from the asynchronous library.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final String LIB_ASYNCIO = "asyncio";
    private static final String LIB_TRIO = "trio";
    private static final String LIB_ANYIO = "anyio";
    private static final String QUICK_FIX_TO_THREAD = "Wrap with await %s.to_thread(input%s)";
    private static final String QUICK_FIX_RUN_SYNC = "Wrap with await %s.to_thread.run_sync(input%s)";
    private TypeCheckBuilder isInputCall;
    private final Map<String, String> asyncLibraryAliases = new LinkedHashMap<String, String>();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.isInputCall = ctx.typeChecker().typeCheckBuilder().isTypeWithName("input");
            this.asyncLibraryAliases.clear();
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, this::checkImportName);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkInputInAsync);
    }

    private void checkImportName(SubscriptionContext ctx) {
        ImportName importName = (ImportName)ctx.syntaxNode();
        for (AliasedName module : importName.modules()) {
            String moduleAlias;
            List<Name> names = module.dottedName().names();
            if (names.size() > 1) continue;
            String moduleName = names.get(0).name();
            Name alias = module.alias();
            String string = moduleAlias = alias != null ? alias.name() : moduleName;
            if (!LIB_ASYNCIO.equals(moduleName) && !LIB_TRIO.equals(moduleName) && !LIB_ANYIO.equals(moduleName)) continue;
            this.asyncLibraryAliases.put(moduleName, moduleAlias);
        }
    }

    private void checkInputInAsync(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Expression callee = callExpression.callee();
        if (this.isInputCall.check(callee.typeV2()) != TriBool.TRUE) {
            return;
        }
        TreeUtils.asyncTokenOfEnclosingFunction(callExpression).ifPresent(asyncKeyword -> {
            String message = this.getMessage();
            PythonCheck.PreciseIssue issue = context.addIssue(callee, message).secondary((Token)asyncKeyword, SECONDARY_MESSAGE);
            this.createQuickFixes(callExpression, callee).forEach(issue::addQuickFix);
        });
    }

    private String getMessage() {
        if (this.asyncLibraryAliases.size() != 1) {
            return MESSAGE_FALLBACK;
        }
        String library = this.asyncLibraryAliases.keySet().iterator().next();
        if (LIB_ASYNCIO.equals(library)) {
            return String.format(MESSAGE_TO_THREAD, this.asyncLibraryAliases.get(LIB_ASYNCIO));
        }
        if (LIB_TRIO.equals(library)) {
            return String.format(MESSAGE_TO_THREAD_RUN_SYNC, this.asyncLibraryAliases.get(LIB_TRIO));
        }
        return String.format(MESSAGE_TO_THREAD_RUN_SYNC, this.asyncLibraryAliases.get(LIB_ANYIO));
    }

    private List<PythonQuickFix> createQuickFixes(CallExpression callExpression, Expression inputCallee) {
        Name inputCalleeName;
        if (inputCallee instanceof Name && !"input".equals((inputCalleeName = (Name)inputCallee).name())) {
            return List.of();
        }
        ArrayList<PythonQuickFix> fixes = new ArrayList<PythonQuickFix>();
        List<Argument> args = callExpression.arguments();
        String argsString = args.stream().map(arg -> TreeUtils.treeToString(arg, false)).filter(Objects::nonNull).collect(Collectors.joining(", "));
        Object argsForTemplate = argsString.isEmpty() ? "" : ", " + argsString;
        this.asyncLibraryAliases.forEach((arg_0, arg_1) -> InputInAsyncCheck.lambda$createQuickFixes$3((String)argsForTemplate, callExpression, fixes, arg_0, arg_1));
        return fixes;
    }

    private static /* synthetic */ void lambda$createQuickFixes$3(String argsForTemplate, CallExpression callExpression, List fixes, String library, String alias) {
        String replacementCall = LIB_ASYNCIO.equals(library) ? alias + ".to_thread(input" + argsForTemplate + ")" : alias + ".to_thread.run_sync(input" + argsForTemplate + ")";
        String quickFixMsg = LIB_ASYNCIO.equals(library) ? String.format(QUICK_FIX_TO_THREAD, alias, argsForTemplate) : String.format(QUICK_FIX_RUN_SYNC, alias, argsForTemplate);
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix(quickFixMsg).addTextEdit(TextEditUtils.replace(callExpression, "await " + replacementCall)).build();
        fixes.add(quickFix);
    }
}

