/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.SliceExpression;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6663")
public class IndexMethodCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure this object defines an `__index__` method.";
    private static final Set<String> ALLOWED_TYPES = Set.of("NoneType", "slice");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.SUBSCRIPTION, ctx -> IndexMethodCheck.checkSubscription(ctx, (SubscriptionExpression)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.SLICE_ITEM, ctx -> IndexMethodCheck.checkSliceItem(ctx, (SliceItem)ctx.syntaxNode()));
    }

    private static void checkSliceItem(SubscriptionContext ctx, SliceItem sliceItem) {
        SliceExpression sliceExpression = (SliceExpression)TreeUtils.firstAncestorOfKind(sliceItem, Tree.Kind.SLICE_EXPR);
        if (sliceExpression != null && !sliceExpression.object().type().mustBeOrExtend("typing.Sequence")) {
            return;
        }
        if (!IndexMethodCheck.isValidIndex(sliceItem.lowerBound())) {
            ctx.addIssue(sliceItem.lowerBound(), MESSAGE);
        }
        if (!IndexMethodCheck.isValidIndex(sliceItem.upperBound())) {
            ctx.addIssue(sliceItem.upperBound(), MESSAGE);
        }
        if (!IndexMethodCheck.isValidIndex(sliceItem.stride())) {
            ctx.addIssue(sliceItem.stride(), MESSAGE);
        }
    }

    private static void checkSubscription(SubscriptionContext ctx, SubscriptionExpression subscriptionExpression) {
        Expression expressionIndex;
        if (!subscriptionExpression.object().type().mustBeOrExtend("typing.Sequence")) {
            return;
        }
        ExpressionList expressionList = subscriptionExpression.subscripts();
        if (!expressionList.commas().isEmpty()) {
            ctx.addIssue(expressionList, MESSAGE);
        }
        if (!IndexMethodCheck.isValidIndex(expressionIndex = expressionList.expressions().get(0))) {
            ctx.addIssue(expressionIndex, MESSAGE);
        }
    }

    private static boolean isValidIndex(@Nullable Expression expressionIndex) {
        if (expressionIndex == null || ALLOWED_TYPES.stream().anyMatch(t -> expressionIndex.type().canOnlyBe((String)t))) {
            return true;
        }
        return expressionIndex.type().canHaveMember("__index__");
    }
}

