/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6882")
public class IncorrectParameterDatetimeConstructorsCheck
extends PythonSubscriptionCheck {
    private static final int MIN_YEAR = 1;
    private static final int MAX_YEAR = 9999;
    private static final String MESSAGE = "Provide a correct value for the `%s` parameter.";
    private static final String MESSAGE_SECONDARY_LOCATION = "An invalid value is assigned here.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, IncorrectParameterDatetimeConstructorsCheck::checkCallExpr);
    }

    private static void checkCallExpr(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null) {
            return;
        }
        if ("datetime.date".equals(calleeSymbol.fullyQualifiedName())) {
            IncorrectParameterDatetimeConstructorsCheck.checkDate(context, callExpression);
        } else if ("datetime.time".equals(calleeSymbol.fullyQualifiedName())) {
            IncorrectParameterDatetimeConstructorsCheck.checkTime(context, callExpression);
        } else if ("datetime.datetime".equals(calleeSymbol.fullyQualifiedName())) {
            IncorrectParameterDatetimeConstructorsCheck.checkDate(context, callExpression);
            IncorrectParameterDatetimeConstructorsCheck.checkTime(context, callExpression, 3);
        }
    }

    private static void checkTime(SubscriptionContext context, CallExpression callExpression) {
        IncorrectParameterDatetimeConstructorsCheck.checkTime(context, callExpression, 0);
    }

    private static void checkTime(SubscriptionContext context, CallExpression callExpression, int parameterOffset) {
        RegularArgument hourArgument = TreeUtils.nthArgumentOrKeyword(parameterOffset, "hour", callExpression.arguments());
        RegularArgument minuteArgument = TreeUtils.nthArgumentOrKeyword(parameterOffset + 1, "minute", callExpression.arguments());
        RegularArgument secondArgument = TreeUtils.nthArgumentOrKeyword(parameterOffset + 2, "second", callExpression.arguments());
        RegularArgument microsecondArgument = TreeUtils.nthArgumentOrKeyword(parameterOffset + 3, "microsecond", callExpression.arguments());
        if (hourArgument != null) {
            IncorrectParameterDatetimeConstructorsCheck.checkArgument(context, hourArgument, 0L, 23L, "hour");
        }
        if (minuteArgument != null) {
            IncorrectParameterDatetimeConstructorsCheck.checkArgument(context, minuteArgument, 0L, 59L, "minute");
        }
        if (secondArgument != null) {
            IncorrectParameterDatetimeConstructorsCheck.checkArgument(context, secondArgument, 0L, 59L, "second");
        }
        if (microsecondArgument != null) {
            IncorrectParameterDatetimeConstructorsCheck.checkArgument(context, microsecondArgument, 0L, 999999L, "microsecond");
        }
    }

    private static ValueWithExpression getValue(Expression expression) {
        if (expression.is(Tree.Kind.NUMERIC_LITERAL)) {
            return new ValueWithExpression(((NumericLiteral)expression).valueAsLong(), expression);
        }
        if (expression.is(Tree.Kind.UNARY_MINUS)) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            if (!unaryExpression.expression().is(Tree.Kind.NUMERIC_LITERAL)) {
                return null;
            }
            return new ValueWithExpression(-((NumericLiteral)unaryExpression.expression()).valueAsLong(), unaryExpression);
        }
        if (expression.is(Tree.Kind.NAME)) {
            return Expressions.singleAssignedNonNameValue((Name)expression).map(IncorrectParameterDatetimeConstructorsCheck::getValue).orElse(null);
        }
        return null;
    }

    private static void checkArgument(SubscriptionContext context, RegularArgument argument, long min, long max, String name) {
        Tree secondaryLocation;
        ValueWithExpression valueWithExpression = IncorrectParameterDatetimeConstructorsCheck.getValue(argument.expression());
        if (valueWithExpression == null) {
            return;
        }
        long value = valueWithExpression.value();
        Tree tree = secondaryLocation = argument.expression() == valueWithExpression.expression() ? null : valueWithExpression.expression();
        if (value < min || value > max) {
            PythonCheck.PreciseIssue issue = context.addIssue(argument, String.format(MESSAGE, name));
            if (secondaryLocation != null) {
                issue.secondary(secondaryLocation, MESSAGE_SECONDARY_LOCATION);
            }
        }
    }

    private static void checkDate(SubscriptionContext context, CallExpression callExpression) {
        RegularArgument yearArgument = TreeUtils.nthArgumentOrKeyword(0, "year", callExpression.arguments());
        RegularArgument monthArgument = TreeUtils.nthArgumentOrKeyword(1, "month", callExpression.arguments());
        RegularArgument dayArgument = TreeUtils.nthArgumentOrKeyword(2, "day", callExpression.arguments());
        if (yearArgument == null || monthArgument == null || dayArgument == null) {
            return;
        }
        IncorrectParameterDatetimeConstructorsCheck.checkArgument(context, yearArgument, 1L, 9999L, "year");
        IncorrectParameterDatetimeConstructorsCheck.checkArgument(context, monthArgument, 1L, 12L, "month");
        IncorrectParameterDatetimeConstructorsCheck.checkArgument(context, dayArgument, 1L, 31L, "day");
    }

    private static class ValueWithExpression {
        private final long value;
        private final Tree expression;

        public ValueWithExpression(long value, Tree expression) {
            this.value = value;
            this.expression = expression;
        }

        public long value() {
            return this.value;
        }

        public Tree expression() {
            return this.expression;
        }
    }
}

