/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.BuiltinSymbols;

@Rule(key="S5632")
public class IncorrectExceptionTypeCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Change this code so that it raises an object deriving from BaseException.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            RaiseStatement raiseStatement = (RaiseStatement)ctx.syntaxNode();
            if (raiseStatement.expressions().isEmpty()) {
                return;
            }
            Expression raisedExpression = raiseStatement.expressions().get(0);
            Symbol symbol = null;
            if (raisedExpression instanceof HasSymbol) {
                HasSymbol hasSymbol = (HasSymbol)((Object)raisedExpression);
                symbol = hasSymbol.symbol();
            } else if (raisedExpression.is(Tree.Kind.CALL_EXPR)) {
                symbol = ((CallExpression)raisedExpression).calleeSymbol();
            }
            if (IncorrectExceptionTypeCheck.hasGlobalOrNonLocalUsage(symbol)) {
                return;
            }
            if (!raisedExpression.type().canBeOrExtend("BaseException") && !raisedExpression.type().canBeOrExtend("type")) {
                ctx.addIssue(raiseStatement, MESSAGE);
                return;
            }
            if (!IncorrectExceptionTypeCheck.mayInheritFromBaseException(symbol)) {
                ctx.addIssue(raiseStatement, MESSAGE);
            }
        });
    }

    private static boolean mayInheritFromBaseException(@Nullable Symbol symbol) {
        if (symbol == null) {
            return true;
        }
        if (BuiltinSymbols.EXCEPTIONS.contains(symbol.fullyQualifiedName()) || BuiltinSymbols.EXCEPTIONS_PYTHON2.contains(symbol.fullyQualifiedName())) {
            return true;
        }
        if (symbol.is(Symbol.Kind.CLASS)) {
            return ((ClassSymbol)symbol).canBeOrExtend("BaseException");
        }
        return !BuiltinSymbols.all().contains(symbol.fullyQualifiedName());
    }

    private static boolean hasGlobalOrNonLocalUsage(@Nullable Symbol symbol) {
        return symbol != null && symbol.usages().stream().anyMatch(s -> s.tree().parent().is(Tree.Kind.GLOBAL_STMT, Tree.Kind.NONLOCAL_STMT));
    }
}

