/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S5799")
public class ImplicitStringConcatenationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_SINGLE_LINE = "Merge these implicitly concatenated strings; or did you forget a comma?";
    private static final String MESSAGE_MULTIPLE_LINES = "Add a \"+\" operator to make the string concatenation explicit; or did you forget a comma?";
    private static final int MAX_COLUMN = 65;
    private static final Pattern END_LINE_PATTERN = Pattern.compile("^.*(\\\\n|\\s|\\p{IsPunct})$");
    private static final Pattern START_LINE_PATTERN = Pattern.compile("^(\\\\n|\\s|\\p{IsPunct}).*");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, ctx -> {
            StringLiteral stringLiteral = (StringLiteral)ctx.syntaxNode();
            if (stringLiteral.parent().is(Tree.Kind.MODULO, Tree.Kind.QUALIFIED_EXPR)) {
                return;
            }
            if (stringLiteral.stringElements().size() == 1) {
                return;
            }
            ImplicitStringConcatenationCheck.checkStringLiteral(stringLiteral, ctx);
        });
    }

    private static void checkStringLiteral(StringLiteral stringLiteral, SubscriptionContext ctx) {
        List<StringElement> stringElements = stringLiteral.stringElements();
        for (int i = 1; i < stringElements.size(); ++i) {
            StringElement current = stringElements.get(i);
            StringElement previous = stringElements.get(i - 1);
            if (!current.prefix().equalsIgnoreCase(previous.prefix()) || !ImplicitStringConcatenationCheck.haveSameQuotes(current, previous)) continue;
            if (current.firstToken().line() == previous.firstToken().line()) {
                ImplicitStringConcatenationCheck.createQuickFix(ctx.addIssue(previous.firstToken(), MESSAGE_SINGLE_LINE).secondary(current.firstToken(), null), previous, current);
                return;
            }
            if (!ImplicitStringConcatenationCheck.isWithinCollection(stringLiteral) || ImplicitStringConcatenationCheck.isException(previous, current)) continue;
            ImplicitStringConcatenationCheck.createQuickFix(ctx.addIssue(previous.firstToken(), MESSAGE_MULTIPLE_LINES).secondary(current.firstToken(), null), previous, current);
            return;
        }
    }

    private static boolean isException(StringElement first, StringElement second) {
        if (first.firstToken().column() + first.value().length() > 65) {
            return true;
        }
        return END_LINE_PATTERN.matcher(first.trimmedQuotesValue()).matches() || START_LINE_PATTERN.matcher(second.trimmedQuotesValue()).matches();
    }

    private static boolean isWithinCollection(StringLiteral stringLiteral) {
        return stringLiteral.parent().is(Tree.Kind.TUPLE, Tree.Kind.EXPRESSION_LIST);
    }

    private static boolean haveSameQuotes(StringElement first, StringElement second) {
        return first.isTripleQuoted() == second.isTripleQuoted() && first.value().charAt(first.value().length() - 1) == second.value().charAt(second.value().length() - 1);
    }

    private static boolean isInFunctionOrArrayOrTupleOrExpressionOrSet(StringElement token) {
        Tree t = token;
        while (t.parent().is(Tree.Kind.STRING_LITERAL)) {
            t = t.parent();
        }
        Tree parent = t.parent();
        return parent.is(Tree.Kind.EXPRESSION_LIST, Tree.Kind.PLUS, Tree.Kind.REGULAR_ARGUMENT, Tree.Kind.SET_LITERAL, Tree.Kind.TUPLE);
    }

    private static void createQuickFix(PythonCheck.PreciseIssue issue, StringElement start, StringElement end) {
        PythonQuickFix quickFix;
        String textStart = start.value();
        String textEnd = end.value();
        if (ImplicitStringConcatenationCheck.isInFunctionOrArrayOrTupleOrExpressionOrSet(start)) {
            quickFix = PythonQuickFix.newQuickFix("Add the comma between string or byte tokens.").addTextEdit(TextEditUtils.insertAfter(start, ",")).build();
            issue.addQuickFix(quickFix);
        }
        quickFix = PythonQuickFix.newQuickFix("Make the addition sign between string or byte tokens explicit.").addTextEdit(TextEditUtils.replaceRange(start, end, textStart + " + " + textEnd)).build();
        issue.addQuickFix(quickFix);
    }
}

