/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5754")
public class IgnoredSystemExitCheck
extends PythonSubscriptionCheck {
    private static final String BASE_EXCEPTION_NAME = "BaseException";
    private static final String SYSTEM_EXIT_EXCEPTION_NAME = "SystemExit";
    private static final String MESSAGE_NOT_RERAISED_CAUGHT_EXCEPTION = "Reraise this exception to stop the application as the user expects";
    private static final String MESSAGE_BARE_EXCEPT = "Specify an exception class to catch or reraise the exception";
    private static final String MESSAGE_NOT_RERAISED_BASE_EXCEPTION = "Catch a more specific exception or reraise the exception";
    private static final String SYSTEM_EXIT_FUNCTION_NAME = "sys.exit";
    private static final String SYSTEM_EXC_INFO_NAME = "sys.exc_info";
    public static final String QUICK_FIX_MESSAGE = "Propagate the exception";

    @CheckForNull
    private static Symbol findExceptionInstanceSymbol(@Nullable Expression exceptionInstance) {
        Symbol exceptionInstanceSymbol = null;
        if (exceptionInstance instanceof HasSymbol) {
            HasSymbol hasSymbol = (HasSymbol)((Object)exceptionInstance);
            exceptionInstanceSymbol = hasSymbol.symbol();
        }
        return exceptionInstanceSymbol;
    }

    @CheckForNull
    private static String findExceptionName(Expression exception) {
        HasSymbol hasSymbol;
        Symbol exceptionSymbol;
        if (exception instanceof HasSymbol && (exceptionSymbol = (hasSymbol = (HasSymbol)((Object)exception)).symbol()) != null) {
            return exceptionSymbol.fullyQualifiedName();
        }
        return null;
    }

    private static void handlePossibleBareException(SubscriptionContext ctx, ExceptClause exceptClause, boolean isSystemExitHandled) {
        ExceptionReRaiseCheckVisitor visitor = new ExceptionReRaiseCheckVisitor(null);
        exceptClause.accept(visitor);
        if (!visitor.isReRaised && !isSystemExitHandled) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(exceptClause.exceptKeyword(), MESSAGE_BARE_EXCEPT);
            IgnoredSystemExitCheck.addQuickFix(exceptClause, issue);
        }
    }

    private static boolean handleCaughtException(SubscriptionContext ctx, Expression caughtException, @Nullable Symbol exceptionInstanceSymbol, Tree exceptionBody, boolean handledSystemExit) {
        String caughtExceptionName = IgnoredSystemExitCheck.findExceptionName(caughtException);
        if (caughtExceptionName == null) {
            return false;
        }
        ExceptionReRaiseCheckVisitor visitor = new ExceptionReRaiseCheckVisitor(exceptionInstanceSymbol);
        exceptionBody.accept(visitor);
        if (visitor.isReRaised) {
            return SYSTEM_EXIT_EXCEPTION_NAME.equals(caughtExceptionName);
        }
        if (SYSTEM_EXIT_EXCEPTION_NAME.equals(caughtExceptionName)) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(caughtException, MESSAGE_NOT_RERAISED_CAUGHT_EXCEPTION);
            IgnoredSystemExitCheck.addQuickFix(caughtException, issue);
            return true;
        }
        if (BASE_EXCEPTION_NAME.equals(caughtExceptionName) && !handledSystemExit) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(caughtException, MESSAGE_NOT_RERAISED_BASE_EXCEPTION);
            IgnoredSystemExitCheck.addQuickFix(caughtException, issue);
        }
        return false;
    }

    private static void addQuickFix(Expression caughtException, PythonCheck.PreciseIssue issue) {
        Optional.of(caughtException).map(e -> TreeUtils.firstAncestor(caughtException, p -> p.is(Tree.Kind.EXCEPT_CLAUSE))).map(ExceptClause.class::cast).ifPresent(exceptClause -> IgnoredSystemExitCheck.addQuickFix(exceptClause, issue));
    }

    private static void addQuickFix(ExceptClause exceptClause, PythonCheck.PreciseIssue issue) {
        List<Statement> bodyStatements = exceptClause.body().statements();
        Statement lastStatement = bodyStatements.get(bodyStatements.size() - 1);
        PythonQuickFix.Builder quickFixBuilder = PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE);
        if (lastStatement.is(Tree.Kind.PASS_STMT) || TreeUtils.hasDescendant(lastStatement, c -> c.is(Tree.Kind.ELLIPSIS))) {
            quickFixBuilder.addTextEdit(TextEditUtils.replace(lastStatement, "raise"));
        } else {
            Token lastToken = lastStatement.lastToken();
            quickFixBuilder.addTextEdit(TextEditUtils.insertLineAfter(lastToken, lastStatement, "raise"));
        }
        issue.addQuickFix(quickFixBuilder.build());
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TRY_STMT, ctx -> {
            TryStatement tryStatement = (TryStatement)ctx.syntaxNode();
            boolean isSystemExitHandled = false;
            for (ExceptClause exceptClause : tryStatement.exceptClauses()) {
                Expression exceptionExpr = exceptClause.exception();
                if (exceptionExpr == null) {
                    IgnoredSystemExitCheck.handlePossibleBareException(ctx, exceptClause, isSystemExitHandled);
                    break;
                }
                Expression exceptionInstance = exceptClause.exceptionInstance();
                Symbol exceptionInstanceSymbol = IgnoredSystemExitCheck.findExceptionInstanceSymbol(exceptionInstance);
                List<Expression> caughtExceptions = TreeUtils.flattenTuples(exceptionExpr).toList();
                for (Expression caughtException : caughtExceptions) {
                    isSystemExitHandled |= IgnoredSystemExitCheck.handleCaughtException(ctx, caughtException, exceptionInstanceSymbol, exceptClause.body(), isSystemExitHandled);
                }
            }
        });
    }

    private static class ExceptionReRaiseCheckVisitor
    extends BaseTreeVisitor {
        private Symbol exceptionInstance;
        private boolean isReRaised;

        public ExceptionReRaiseCheckVisitor(@Nullable Symbol exceptionInstance) {
            this.exceptionInstance = exceptionInstance;
        }

        @Override
        public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
            if (pyRaiseStatementTree.expressions().isEmpty()) {
                this.isReRaised = true;
                return;
            }
            Expression raisedException = pyRaiseStatementTree.expressions().get(0);
            if (raisedException.type().canOnlyBe(IgnoredSystemExitCheck.SYSTEM_EXIT_EXCEPTION_NAME)) {
                this.isReRaised = true;
            }
            if (raisedException instanceof HasSymbol) {
                HasSymbol hasSymbol = (HasSymbol)((Object)raisedException);
                Symbol symbol = hasSymbol.symbol();
                if (symbol == null) {
                    return;
                }
                if (symbol.equals(this.exceptionInstance)) {
                    this.isReRaised = true;
                }
            }
        }

        @Override
        public void visitCallExpression(CallExpression pyCallExpressionTree) {
            Symbol symbol = pyCallExpressionTree.calleeSymbol();
            if (symbol == null) {
                return;
            }
            String fqn = symbol.fullyQualifiedName();
            this.isReRaised |= IgnoredSystemExitCheck.SYSTEM_EXIT_FUNCTION_NAME.equals(fqn);
            this.isReRaised |= IgnoredSystemExitCheck.SYSTEM_EXC_INFO_NAME.equals(fqn);
        }
    }
}

