/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.checks.utils.GraphQLUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6785")
public class GraphQLDenialOfServiceCheck
extends PythonSubscriptionCheck {
    private static final Set<String> SAFE_VALIDATION_RULE_FQNS = Set.of("graphene.validation.DepthLimitValidator");
    private static final List<String> VALID_MIDDLEWARE_NAMES = List.of("DEPTH", "COST");
    private static final String MESSAGE_DEPTH = "Change this code to limit the depth of GraphQL queries.";
    private static final String MESSAGE_CIRCULAR = "This relationship creates circular references.";
    private final Set<Tree> circularReferences = new HashSet<Tree>();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::searchForCircularReferences);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkGraphQLDepthLimit);
    }

    private void searchForCircularReferences(SubscriptionContext ctx) {
        this.circularReferences.clear();
        CircularRelationshipVisitor classVisitor = new CircularRelationshipVisitor(this.circularReferences);
        ctx.syntaxNode().accept(classVisitor);
    }

    private void checkGraphQLDepthLimit(SubscriptionContext ctx) {
        if (this.circularReferences.isEmpty()) {
            return;
        }
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        List<Argument> arguments = callExpression.arguments();
        Optional.of(callExpression).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).filter(GraphQLUtils::isCallToAsView).map(QualifiedExpression::qualifier).filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).filter(GraphQLUtils::isOrExtendsGraphQLView).filter(fqn -> !GraphQLDenialOfServiceCheck.hasSafeValidationRules(arguments)).filter(fqn -> !GraphQLDenialOfServiceCheck.hasSafeMiddlewares(arguments)).ifPresent(fqn -> {
            PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(callExpression.callee(), MESSAGE_DEPTH);
            this.circularReferences.forEach(circularRef -> preciseIssue.secondary((Tree)circularRef, MESSAGE_CIRCULAR));
        });
    }

    private static boolean hasSafeMiddlewares(List<Argument> arguments) {
        RegularArgument argument = TreeUtils.argumentByKeyword("middleware", arguments);
        if (argument == null) {
            return false;
        }
        Optional<Expression> argumentValue = Expressions.ifNameGetSingleAssignedNonNameValue(argument.expression());
        boolean isNotTupleNorListLiteral = argumentValue.filter(a -> a.is(Tree.Kind.LIST_LITERAL, Tree.Kind.TUPLE)).isEmpty();
        return isNotTupleNorListLiteral || Expressions.expressionsFromListOrTuple(argumentValue.get()).stream().anyMatch(GraphQLDenialOfServiceCheck::isSafeMiddlewareName);
    }

    private static boolean hasSafeValidationRules(List<Argument> arguments) {
        RegularArgument argument = TreeUtils.argumentByKeyword("validation_rules", arguments);
        if (argument == null) {
            return false;
        }
        Optional<Expression> argumentValue = Expressions.ifNameGetSingleAssignedNonNameValue(argument.expression());
        boolean isNotTupleNorListLiteral = argumentValue.filter(a -> a.is(Tree.Kind.LIST_LITERAL, Tree.Kind.TUPLE)).isEmpty();
        return isNotTupleNorListLiteral || Expressions.expressionsFromListOrTuple(argumentValue.get()).stream().anyMatch(GraphQLDenialOfServiceCheck::isSafeValidationRule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSafeValidationRule(Expression value) {
        if (GraphQLDenialOfServiceCheck.isSafeMiddlewareName(value)) return true;
        if (!GraphQLUtils.expressionFQNMatchPredicate(value, SAFE_VALIDATION_RULE_FQNS::contains)) return false;
        return true;
    }

    private static boolean isSafeMiddlewareName(Expression value) {
        return GraphQLUtils.expressionTypeOrNameMatchPredicate(value, name -> VALID_MIDDLEWARE_NAMES.stream().anyMatch(mwName -> name.toUpperCase(Locale.ROOT).contains((CharSequence)mwName)));
    }

    static class CircularRelationshipVisitor
    extends BaseTreeVisitor {
        final Set<Tree> circularReferences;

        public CircularRelationshipVisitor(Set<Tree> circularReferences) {
            this.circularReferences = circularReferences;
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            TreeUtils.toOptionalInstanceOf(QualifiedExpression.class, callExpression.callee()).filter(qualifiedExpression -> "relationship".equals(qualifiedExpression.name().name())).map(QualifiedExpression::qualifier).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).flatMap(Expressions::singleAssignedNonNameValue).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).map(CallExpression::callee).filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).filter("flask_sqlalchemy.SQLAlchemy"::equals).ifPresent(s -> this.circularReferences.add(callExpression));
            super.visitCallExpression(callExpression);
        }
    }
}

