/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAliasStatement;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6795")
public class GenericTypeStatementCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a generic type parameter instead of a \"TypeVar\" in this type statement.";
    private static final String SECONDARY_MESSAGE_USE = "Use of \"TypeVar\" here.";
    private static final String SECONDARY_MESSAGE_ASSIGNMENT = "\"TypeVar\" is assigned here.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TYPE_ALIAS_STMT, GenericTypeStatementCheck::checkUseOfGenerics);
    }

    private static void checkUseOfGenerics(SubscriptionContext ctx) {
        if (!GenericTypeStatementCheck.supportsTypeParameterSyntax(ctx)) {
            return;
        }
        TypeAliasStatement typeStatement = (TypeAliasStatement)ctx.syntaxNode();
        Set<Tree> typeVarAsTypeParameter = Optional.ofNullable(typeStatement.expression()).flatMap(TreeUtils.toOptionalInstanceOfMapper(SubscriptionExpression.class)).map(SubscriptionExpression::subscripts).map(ExpressionList::expressions).stream().flatMap(Collection::stream).filter(Expressions::isGenericTypeAnnotation).collect(Collectors.toSet());
        if (!typeVarAsTypeParameter.isEmpty()) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(typeStatement.name(), MESSAGE);
            typeVarAsTypeParameter.forEach(loc -> issue.secondary((Tree)loc, SECONDARY_MESSAGE_USE));
            GenericTypeStatementCheck.getAssignmentLocations(typeVarAsTypeParameter).forEach(loc -> issue.secondary((Tree)loc, SECONDARY_MESSAGE_ASSIGNMENT));
        }
    }

    private static Set<Tree> getAssignmentLocations(Set<Tree> secondaryLocations) {
        return secondaryLocations.stream().map(Name.class::cast).map(Expressions::singleAssignedValue).collect(Collectors.toSet());
    }

    private static boolean supportsTypeParameterSyntax(SubscriptionContext ctx) {
        return PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan(ctx.sourcePythonVersions(), PythonVersionUtils.Version.V_312);
    }
}

