/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5886")
public class FunctionReturnTypeCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Return a value of type \"%s\" instead of \"%s\" or update function \"%s\" type hint.";
    private static final Set<String> ITERABLE_TYPES = Set.of("typing.Generator", "typing.Iterator", "typing.Iterable", "collections.abc.Generator", "collections.abc.Iterator", "collections.abc.Iterable");
    private static final Set<String> ASYNC_ITERABLE_TYPES = Set.of("typing.AsyncGenerator", "typing.AsyncIterator", "typing.AsyncIterable", "collections.abc.AsyncGenerator", "collections.abc.AsyncIterator", "collections.abc.AsyncIterable");
    private static final String CONTEXT_MANAGER_DECORATOR_FQN = "contextlib.contextmanager";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            Symbol symbol = functionDef.name().symbol();
            if (symbol == null || !symbol.is(Symbol.Kind.FUNCTION)) {
                return;
            }
            if (FunctionReturnTypeCheck.isContextManager(functionDef)) {
                return;
            }
            FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
            InferredType declaredReturnType = functionSymbol.declaredReturnType();
            if (declaredReturnType == InferredTypes.anyType()) {
                return;
            }
            ReturnTypeVisitor returnTypeVisitor = new ReturnTypeVisitor(declaredReturnType);
            functionDef.body().accept(returnTypeVisitor);
            FunctionReturnTypeCheck.raiseIssues(ctx, functionDef, declaredReturnType, returnTypeVisitor);
        });
    }

    private static boolean isContextManager(FunctionDef functionDef) {
        return functionDef.decorators().stream().map(Decorator::expression).filter(QualifiedExpression.class::isInstance).map(QualifiedExpression.class::cast).map(QualifiedExpression::symbol).filter(Objects::nonNull).map(Symbol::fullyQualifiedName).anyMatch(CONTEXT_MANAGER_DECORATOR_FQN::equals);
    }

    private static void raiseIssues(SubscriptionContext ctx, FunctionDef functionDef, InferredType declaredReturnType, ReturnTypeVisitor returnTypeVisitor) {
        String functionName = functionDef.name().name();
        String returnTypeName = InferredTypes.typeName(declaredReturnType);
        if (!returnTypeVisitor.yieldExpressions.isEmpty()) {
            String recommendedSuperType;
            boolean isAsyncFunction = functionDef.asyncKeyword() != null;
            String string = recommendedSuperType = isAsyncFunction ? "typing.AsyncGenerator" : "typing.Generator";
            if (FunctionReturnTypeCheck.canBeOrExtendIterableType(declaredReturnType)) {
                if (FunctionReturnTypeCheck.isMixedUpAnnotation(isAsyncFunction, declaredReturnType)) {
                    returnTypeVisitor.yieldExpressions.forEach(y -> {
                        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)y, String.format("Annotate function \"%s\" with \"%s\" or one of its supertypes.", functionName, recommendedSuperType));
                        FunctionReturnTypeCheck.addSecondaries(issue, functionDef);
                    });
                }
                return;
            }
            returnTypeVisitor.yieldExpressions.forEach(y -> {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)y, String.format("Remove this yield statement or annotate function \"%s\" with \"%s\" or one of its supertypes.", functionName, recommendedSuperType));
                FunctionReturnTypeCheck.addSecondaries(issue, functionDef);
            });
        }
        returnTypeVisitor.invalidReturnStatements.forEach(i -> {
            PythonCheck.PreciseIssue issue = i.expressions().size() > 1 ? ctx.addIssue((Tree)i, String.format(MESSAGE, returnTypeName, "tuple", functionName)) : (i.expressions().size() == 1 && InferredTypes.typeName(i.expressions().get(0).type()) != null ? ctx.addIssue(i.expressions().get(0), String.format(MESSAGE, returnTypeName, InferredTypes.typeName(i.expressions().get(0).type()), functionName)) : ctx.addIssue((Tree)i, String.format("Return a value of type \"%s\" or update function \"%s\" type hint.", returnTypeName, functionName)));
            FunctionReturnTypeCheck.addSecondaries(issue, functionDef);
        });
    }

    private static boolean canBeOrExtendIterableType(InferredType inferredType) {
        return Stream.concat(ITERABLE_TYPES.stream(), ASYNC_ITERABLE_TYPES.stream()).anyMatch(typeName -> FunctionReturnTypeCheck.canBeOrExtend(inferredType, typeName));
    }

    private static boolean canBeOrExtend(InferredType inferredType, String typeName) {
        return Optional.of(inferredType).filter(DeclaredType.class::isInstance).map(DeclaredType.class::cast).map(DeclaredType::getTypeClass).filter(ClassSymbol.class::isInstance).map(ClassSymbol.class::cast).map(s -> s.canBeOrExtend(typeName)).orElseGet(() -> inferredType.canBeOrExtend(typeName));
    }

    private static boolean isMixedUpAnnotation(boolean isAsyncFunction, InferredType declaredReturnType) {
        return isAsyncFunction ? ITERABLE_TYPES.stream().anyMatch(declaredReturnType::mustBeOrExtend) : ASYNC_ITERABLE_TYPES.stream().anyMatch(declaredReturnType::mustBeOrExtend);
    }

    private static void addSecondaries(PythonCheck.PreciseIssue issue, FunctionDef functionDef) {
        issue.secondary(functionDef.name(), "Function definition.");
        TypeAnnotation returnTypeAnnotation = functionDef.returnTypeAnnotation();
        if (returnTypeAnnotation != null) {
            issue.secondary(returnTypeAnnotation.expression(), "Type hint.");
        }
    }

    private static class ReturnTypeVisitor
    extends BaseTreeVisitor {
        InferredType returnType;
        List<YieldExpression> yieldExpressions = new ArrayList<YieldExpression>();
        List<ReturnStatement> invalidReturnStatements = new ArrayList<ReturnStatement>();

        ReturnTypeVisitor(InferredType returnType) {
            this.returnType = returnType;
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
        }

        @Override
        public void visitReturnStatement(ReturnStatement returnStatement) {
            List<Expression> expressions = returnStatement.expressions();
            if (expressions.isEmpty()) {
                if (!InferredTypes.NONE.isCompatibleWith(this.returnType)) {
                    this.invalidReturnStatements.add(returnStatement);
                }
            } else if (!returnStatement.commas().isEmpty()) {
                if (!InferredTypes.TUPLE.isCompatibleWith(this.returnType)) {
                    this.invalidReturnStatements.add(returnStatement);
                }
            } else {
                Expression expression = expressions.get(0);
                InferredType inferredType = expression.type();
                if (this.returnType.mustBeOrExtend("typing.TypedDict")) {
                    return;
                }
                if (!InferredTypes.containsDeclaredType(inferredType) && !inferredType.isCompatibleWith(this.returnType)) {
                    this.invalidReturnStatements.add(returnStatement);
                }
            }
            super.visitReturnStatement(returnStatement);
        }

        @Override
        public void visitYieldExpression(YieldExpression yieldExpression) {
            this.yieldExpressions.add(yieldExpression);
            super.visitYieldExpression(yieldExpression);
        }
    }
}

