/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

public abstract class FlaskHardCodedSecret
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Don't disclose %s secret keys.";
    private static final String SECONDARY_MESSAGE = "Assignment to sensitive property.";
    private static final Set<String> FLASK_APP_CONFIG_QUALIFIER_FQNS = Set.of("flask.app.Flask.config", "flask.globals.current_app.config");
    public static final String SECONDARY_LOCATION_MESSAGE = "The secret is used in this call.";

    protected abstract String getSecretKeyKeyword();

    protected abstract String getSecretKeyType();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::verifyCallExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::verifyAssignmentStatement);
    }

    private void verifyCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Optional.of(callExpression).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).filter(qualiExpr -> "update".equals(qualiExpr.name().name())).map(QualifiedExpression::qualifier).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::name).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).filter(FLASK_APP_CONFIG_QUALIFIER_FQNS::contains).ifPresent(fqn -> this.verifyUpdateCallArgument(ctx, callExpression));
    }

    private void verifyUpdateCallArgument(SubscriptionContext ctx, CallExpression callExpression) {
        Optional.of(callExpression.arguments()).filter(arguments -> arguments.size() == 1).map(arguments -> (Argument)arguments.get(0)).flatMap(TreeUtils.toOptionalInstanceOfMapper(RegularArgument.class)).map(RegularArgument::expression).map(FlaskHardCodedSecret::getAssignedValue).flatMap(this::getIllegalDictArgument).ifPresent(illegalArgument -> ctx.addIssue((Tree)illegalArgument, this.getMessage()).secondary(callExpression.callee(), SECONDARY_LOCATION_MESSAGE));
    }

    private String getMessage() {
        return String.format(MESSAGE, this.getSecretKeyType());
    }

    private static Expression getAssignedValue(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            return Expressions.singleAssignedValue((Name)expression);
        }
        return expression;
    }

    private Optional<Tree> getIllegalDictArgument(Expression expression) {
        if (expression.is(Tree.Kind.CALL_EXPR)) {
            return TreeUtils.toOptionalInstanceOf(CallExpression.class, expression).filter(FlaskHardCodedSecret::isCallToDictConstructor).flatMap(this::getIllegalKeywordArgument);
        }
        if (expression.is(Tree.Kind.DICTIONARY_LITERAL)) {
            return TreeUtils.toOptionalInstanceOf(DictionaryLiteral.class, expression).flatMap(this::getIllegalKeyValuePair);
        }
        return Optional.empty();
    }

    private static boolean isCallToDictConstructor(CallExpression callExpression) {
        return Optional.of(callExpression).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).filter("dict"::equals).isPresent();
    }

    private Optional<KeyValuePair> getIllegalKeyValuePair(DictionaryLiteral dictionaryLiteral) {
        return dictionaryLiteral.elements().stream().filter(KeyValuePair.class::isInstance).map(KeyValuePair.class::cast).filter(this::isIllegalKeyValuePair).findFirst();
    }

    private boolean isIllegalKeyValuePair(KeyValuePair keyValuePair) {
        return Optional.of(keyValuePair.key()).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).map(StringLiteral::trimmedQuotesValue).filter(this.getSecretKeyKeyword()::equals).isPresent() && FlaskHardCodedSecret.isStringValue(keyValuePair.value());
    }

    private Optional<RegularArgument> getIllegalKeywordArgument(CallExpression callExpression) {
        return Optional.ofNullable(TreeUtils.argumentByKeyword(this.getSecretKeyKeyword(), callExpression.arguments())).filter(argument -> Optional.of(argument).map(RegularArgument::expression).filter(FlaskHardCodedSecret::isStringValue).isPresent());
    }

    private void verifyAssignmentStatement(SubscriptionContext ctx) {
        AssignmentStatement assignmentStatementTree = (AssignmentStatement)ctx.syntaxNode();
        if (!FlaskHardCodedSecret.isStringValue(assignmentStatementTree.assignedValue())) {
            return;
        }
        List<Expression> expressionList = assignmentStatementTree.lhsExpressions().stream().map(ExpressionList::expressions).flatMap(Collection::stream).filter(this::isSensitiveProperty).toList();
        if (!expressionList.isEmpty()) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(assignmentStatementTree.assignedValue(), this.getMessage());
            expressionList.forEach(expr -> issue.secondary((Tree)expr, SECONDARY_MESSAGE));
        }
    }

    protected boolean isSensitiveProperty(Expression expression) {
        if (!expression.is(Tree.Kind.SUBSCRIPTION)) {
            return false;
        }
        return Optional.of((SubscriptionExpression)expression).map(SubscriptionExpression::object).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::symbol).map(Symbol::fullyQualifiedName).filter(FLASK_APP_CONFIG_QUALIFIER_FQNS::contains).map(fqn -> ((SubscriptionExpression)expression).subscripts()).map(ExpressionList::expressions).filter(list -> list.size() == 1).map(list -> (Expression)list.get(0)).map(FlaskHardCodedSecret::getAssignedValue).flatMap(TreeUtils.toOptionalInstanceOfMapper(StringLiteral.class)).map(StringLiteral::trimmedQuotesValue).filter(this.getSecretKeyKeyword()::equals).isPresent();
    }

    private static boolean isStringValue(@Nullable Expression expr) {
        return FlaskHardCodedSecret.isStringValue(expr, new HashSet<String>());
    }

    private static boolean isStringValue(@Nullable Expression expr, Set<String> visited) {
        if (expr == null) {
            return false;
        }
        if (expr.is(Tree.Kind.NAME)) {
            if (visited.contains(((Name)expr).name())) {
                return false;
            }
            visited.add(((Name)expr).name());
            Expression assignmentValueExpression = Expressions.singleAssignedValue((Name)expr);
            return FlaskHardCodedSecret.isStringValue(assignmentValueExpression, visited);
        }
        return expr.is(Tree.Kind.STRING_LITERAL);
    }
}

