/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1451")
public class FileHeaderCopyrightCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_HEADER_FORMAT = "";
    private static final String ADD_HEADER_MESSAGE = "Add a header to this file.";
    private static final String UPDATE_HEADER_MESSAGE = "Update the header of this file to match the expected one.";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Pattern searchPattern = null;
    private Pattern shebangPattern = Pattern.compile("^#![^\\n]+\\n", 8);

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            if (this.isRegularExpression && this.searchPattern == null) {
                try {
                    this.searchPattern = Pattern.compile(this.headerFormat, 32);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("[" + this.getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
                }
            }
            if (this.headerFormat.isEmpty()) {
                return;
            }
            String header = FileHeaderCopyrightCheck.getHeaderText(ctx);
            String fileContent = ctx.pythonFile().content();
            String fileContentWithoutShebang = this.shebangPattern.matcher(fileContent).replaceFirst(DEFAULT_HEADER_FORMAT);
            if (header == null && !fileContentWithoutShebang.startsWith("#")) {
                ctx.addFileIssue(ADD_HEADER_MESSAGE);
            } else if (!this.isStartingWithCopyrightHeader(header, fileContentWithoutShebang)) {
                ctx.addFileIssue(UPDATE_HEADER_MESSAGE);
            }
        });
    }

    @Nullable
    private static String getHeaderText(SubscriptionContext ctx) {
        StringLiteral tokenDoc = ((FileInput)ctx.syntaxNode()).docstring();
        if (tokenDoc != null && tokenDoc.firstToken().line() == 1) {
            return tokenDoc.firstToken().value();
        }
        return null;
    }

    private boolean isStartingWithCopyrightHeader(@Nullable String header, String fileContentWithoutShebang) {
        if (this.isRegularExpression) {
            return this.isStartingWithRegexSearchPattern(header, fileContentWithoutShebang);
        }
        return this.isStartingWithNormalSearchPattern(header, fileContentWithoutShebang);
    }

    private boolean isStartingWithRegexSearchPattern(String ... fileContent) {
        return Stream.of(fileContent).filter(Objects::nonNull).map(this.searchPattern::matcher).anyMatch(matcher -> matcher.find() && matcher.start() == 0);
    }

    private boolean isStartingWithNormalSearchPattern(String ... fileContent) {
        return Stream.of(fileContent).filter(Objects::nonNull).anyMatch(content -> content.startsWith(this.headerFormat));
    }
}

