/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.CheckUtils;

@Rule(key="S1700")
public class FieldDuplicatesClassNameCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Rename field \"%s\"";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            if (CheckUtils.classHasInheritance(classDef)) {
                return;
            }
            String className = classDef.name().name();
            HashSet<Symbol> allFields = new HashSet<Symbol>(classDef.classFields());
            allFields.addAll(classDef.instanceFields());
            allFields.stream().filter(symbol -> className.equalsIgnoreCase(symbol.name())).filter(symbol -> symbol.usages().stream().noneMatch(usage -> usage.kind() == Usage.Kind.FUNC_DECLARATION)).forEach(symbol -> symbol.usages().stream().findFirst().ifPresent(usage -> ctx.addIssue(usage.tree(), String.format(MESSAGE, symbol.name())).secondary(classDef.name(), "Class declaration")));
        });
    }
}

