/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S6984")
public class EinopsSyntaxCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_TEMPLATE = "Fix the syntax of this einops operation: %s.";
    private static final String NESTED_PARENTHESIS_MESSAGE = "nested parenthesis are not allowed";
    private static final String LHS_ELLIPSIS_MESSAGE = "Ellipsis inside parenthesis on the left side is not allowed";
    private static final String UNBALANCED_PARENTHESIS_MESSAGE = "parenthesis are unbalanced";
    private static final Set<String> FQN_TO_CHECK = Set.of("einops.repeat", "einops.reduce", "einops.rearrange");
    private static final Pattern ellipsisPattern = Pattern.compile("\\((.*)\\)");
    private TypeCheckMap<Object> einopsCheck = null;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeState);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkEinopsSyntax);
    }

    private void initializeState(SubscriptionContext ctx) {
        this.einopsCheck = new TypeCheckMap();
        for (String fqn : FQN_TO_CHECK) {
            TypeCheckBuilder check = ctx.typeChecker().typeCheckBuilder().isTypeWithName(fqn);
            Object marker = new Object();
            this.einopsCheck.put(check, marker);
        }
    }

    private void checkEinopsSyntax(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (this.einopsCheck.containsForType(callExpression.callee().typeV2())) {
            EinopsSyntaxCheck.extractPatternFromCallExpr(callExpression).ifPresent(stringLiteral -> {
                Optional<EinopsPattern> maybePattern = EinopsSyntaxCheck.toEinopsPattern(stringLiteral);
                if (maybePattern.isPresent()) {
                    EinopsPattern pattern = maybePattern.get();
                    EinopsSyntaxCheck.checkForEllipsisInParenthesis(ctx, pattern);
                    EinopsSyntaxCheck.checkForUnbalancedParenthesis(ctx, pattern);
                    EinopsSyntaxCheck.checkForUnusedParameter(ctx, callExpression.arguments(), pattern);
                } else {
                    ctx.addIssue(callExpression.callee(), "Provide a valid einops pattern.");
                }
            });
        }
    }

    private static void checkForUnusedParameter(SubscriptionContext ctx, List<Argument> arguments, EinopsPattern pattern) {
        List<String> argsToCheck = arguments.stream().map(TreeUtils.toInstanceOfMapper(RegularArgument.class)).filter(Objects::nonNull).filter(arg -> arg.expression().is(Tree.Kind.NUMERIC_LITERAL)).filter(arg -> arg.keywordArgument() != null).map(arg -> arg.keywordArgument().name()).filter(argName -> !pattern.lhs.identifiers.contains(argName)).filter(argName -> !pattern.rhs.identifiers.contains(argName)).toList();
        if (!argsToCheck.isEmpty()) {
            boolean isPlural = argsToCheck.size() > 1;
            String missingParameters = argsToCheck.stream().collect(Collectors.joining(", "));
            String missingParametersMessage = String.format("the parameter%s %s do%s not appear in the pattern", isPlural ? "s" : "", missingParameters, isPlural ? "" : "es");
            ctx.addIssue(pattern.originalPattern(), String.format(MESSAGE_TEMPLATE, missingParametersMessage));
        }
    }

    private static void checkForUnbalancedParenthesis(SubscriptionContext ctx, EinopsPattern pattern) {
        pattern.lhs.state.errorMessage.or(() -> pattern.rhs.state.errorMessage).ifPresent(message -> ctx.addIssue(pattern.originalPattern(), String.format(MESSAGE_TEMPLATE, message)));
    }

    private static void checkForEllipsisInParenthesis(SubscriptionContext ctx, EinopsPattern pattern) {
        Matcher m = ellipsisPattern.matcher(pattern.lhs.originalPattern);
        if (m.find() && (m.group().contains("...") || m.group().contains("\u2026"))) {
            ctx.addIssue(pattern.originalPattern(), String.format(MESSAGE_TEMPLATE, LHS_ELLIPSIS_MESSAGE));
        }
    }

    private static Optional<StringLiteral> extractPatternFromCallExpr(CallExpression callExpression) {
        return Optional.ofNullable(TreeUtils.nthArgumentOrKeyword(1, "pattern", callExpression.arguments())).map(RegularArgument::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(StringLiteral.class));
    }

    private static Optional<EinopsPattern> toEinopsPattern(StringLiteral pattern) {
        String[] split = pattern.trimmedQuotesValue().split("->");
        if (split.length == 2) {
            String lhsStr = split[0].trim();
            String rhsStr = split[1].trim();
            if (!lhsStr.isEmpty() && !rhsStr.isEmpty()) {
                EinopsSide lhs = EinopsSyntaxCheck.parseEinopsPattern(lhsStr);
                EinopsSide rhs = EinopsSyntaxCheck.parseEinopsPattern(rhsStr);
                return Optional.of(new EinopsPattern(pattern, lhs, rhs));
            }
        }
        return Optional.empty();
    }

    private static EinopsSide parseEinopsPattern(String pattern) {
        LinkedHashSet<String> identifiers = new LinkedHashSet<String>();
        StringBuilder currentIdentifier = new StringBuilder();
        ParenthesisState state = new ParenthesisState(false, Optional.empty());
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == ' ' || c == '(' || c == ')') {
                if (!currentIdentifier.isEmpty()) {
                    identifiers.add(currentIdentifier.toString());
                    currentIdentifier.setLength(0);
                }
                state = EinopsSyntaxCheck.checkParenthesisBalance(c, state);
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '\u2026') continue;
            currentIdentifier.append(c);
        }
        if (!currentIdentifier.isEmpty()) {
            identifiers.add(currentIdentifier.toString());
        }
        if (state.hasOpenParenthesis && state.errorMessage.isEmpty()) {
            state = new ParenthesisState(true, Optional.of(UNBALANCED_PARENTHESIS_MESSAGE));
        }
        return new EinopsSide(pattern, identifiers, state);
    }

    private static ParenthesisState checkParenthesisBalance(char c, ParenthesisState state) {
        Optional<String> errorMessage = state.errorMessage;
        if (' ' == c) {
            return state;
        }
        if ('(' == c && state.hasOpenParenthesis) {
            errorMessage = Optional.of(NESTED_PARENTHESIS_MESSAGE);
        }
        if (')' == c && !state.hasOpenParenthesis && errorMessage.isEmpty()) {
            errorMessage = Optional.of(UNBALANCED_PARENTHESIS_MESSAGE);
        }
        return new ParenthesisState('(' == c, errorMessage);
    }

    private record EinopsPattern(StringLiteral originalPattern, EinopsSide lhs, EinopsSide rhs) {
    }

    private record EinopsSide(String originalPattern, Set<String> identifiers, ParenthesisState state) {
    }

    private record ParenthesisState(boolean hasOpenParenthesis, Optional<String> errorMessage) {
    }
}

