/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TokenLocation;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5549")
public class DuplicateArgumentCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol symbol = callExpression.calleeSymbol();
            if (symbol == null || !symbol.is(Symbol.Kind.FUNCTION)) {
                return;
            }
            FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
            boolean isStaticCall = callExpression.callee().is(Tree.Kind.NAME) || Optional.of(callExpression.callee()).filter(c -> c.is(Tree.Kind.QUALIFIED_EXPR)).flatMap(q -> TreeUtils.getSymbolFromTree(((QualifiedExpression)q).qualifier()).filter(s -> s.is(Symbol.Kind.CLASS))).isPresent();
            int firstParameterOffset = SymbolUtils.firstParameterOffset(functionSymbol, isStaticCall);
            if (DuplicateArgumentCheck.isException(functionSymbol) || firstParameterOffset == -1) {
                return;
            }
            DuplicateArgumentCheck.checkFunctionCall(callExpression, functionSymbol, firstParameterOffset, ctx);
        });
    }

    private static void checkFunctionCall(CallExpression callExpression, FunctionSymbol functionSymbol, int firstParameterOffset, SubscriptionContext ctx) {
        HashMap<String, List<Tree>> passedParameters = new HashMap<String, List<Tree>>();
        List<FunctionSymbol.Parameter> parameters = functionSymbol.parameters();
        List<Argument> arguments = callExpression.arguments();
        for (int i = 0; i < arguments.size(); ++i) {
            Argument argument = arguments.get(i);
            if (argument.is(Tree.Kind.REGULAR_ARGUMENT)) {
                RegularArgument regularArgument = (RegularArgument)argument;
                int parameterIndex = i + firstParameterOffset;
                boolean shouldAbortCheck = DuplicateArgumentCheck.checkRegularArgument(regularArgument, parameters, parameterIndex, passedParameters);
                if (!shouldAbortCheck) continue;
                return;
            }
            UnpackingExpression unpackingExpression = (UnpackingExpression)argument;
            boolean isDictionary = unpackingExpression.starToken().type().equals(PythonPunctuator.MUL_MUL);
            if (isDictionary) {
                DuplicateArgumentCheck.checkDictionary(unpackingExpression, passedParameters);
                continue;
            }
            return;
        }
        DuplicateArgumentCheck.reportIssues(passedParameters, functionSymbol, ctx);
    }

    private static boolean checkRegularArgument(RegularArgument regularArgument, List<FunctionSymbol.Parameter> parameters, int parameterIndex, Map<String, List<Tree>> passedParameters) {
        Name keyword = regularArgument.keywordArgument();
        if (keyword == null) {
            if (parameterIndex >= parameters.size()) {
                return false;
            }
            FunctionSymbol.Parameter parameter = parameters.get(parameterIndex);
            if (parameter.name() == null || parameter.isVariadic()) {
                return true;
            }
            if (!parameter.isPositionalOnly()) {
                passedParameters.computeIfAbsent(parameter.name(), k -> new ArrayList()).add(regularArgument);
            }
        } else {
            passedParameters.computeIfAbsent(keyword.name(), k -> new ArrayList()).add(regularArgument);
        }
        return false;
    }

    private static void checkDictionary(UnpackingExpression unpackingExpression, Map<String, List<Tree>> passedParameters) {
        Set<String> dictionaryKeys = DuplicateArgumentCheck.extractKeysFromDictionary(unpackingExpression);
        dictionaryKeys.forEach(key -> passedParameters.computeIfAbsent((String)key, k -> new ArrayList()).add(unpackingExpression));
    }

    private static void reportIssues(Map<String, List<Tree>> passedParameters, FunctionSymbol functionSymbol, SubscriptionContext ctx) {
        passedParameters.forEach((key, list) -> {
            if (list.size() > 1) {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)list.get(0), String.format("Remove duplicate values for parameter \"%s\" in \"%s\" call.", key, functionSymbol.name()));
                LocationInFile locationInFile = functionSymbol.definitionLocation();
                if (locationInFile != null) {
                    issue.secondary(locationInFile, "Function definition.");
                }
                list.stream().skip(1L).forEach(t -> issue.secondary(DuplicateArgumentCheck.locationFromTree(t, ctx), "Argument is also passed here."));
            }
        });
    }

    private static Set<String> extractKeysFromDictionary(UnpackingExpression unpackingExpression) {
        if (unpackingExpression.expression().is(Tree.Kind.DICTIONARY_LITERAL)) {
            return DuplicateArgumentCheck.keysInDictionaryLiteral((DictionaryLiteral)unpackingExpression.expression());
        }
        if (unpackingExpression.expression().is(Tree.Kind.CALL_EXPR)) {
            return DuplicateArgumentCheck.keysFromDictionaryCreation((CallExpression)unpackingExpression.expression());
        }
        if (unpackingExpression.expression().is(Tree.Kind.NAME)) {
            Name name = (Name)unpackingExpression.expression();
            Symbol symbol = name.symbol();
            if (symbol == null || symbol.usages().stream().anyMatch(u -> TreeUtils.firstAncestorOfKind(u.tree(), Tree.Kind.DEL_STMT) != null)) {
                return Collections.emptySet();
            }
            Expression expression = Expressions.singleAssignedValue(name);
            if (expression != null && expression.is(Tree.Kind.CALL_EXPR)) {
                return DuplicateArgumentCheck.keysFromDictionaryCreation((CallExpression)expression);
            }
            return expression != null && expression.is(Tree.Kind.DICTIONARY_LITERAL) ? DuplicateArgumentCheck.keysInDictionaryLiteral((DictionaryLiteral)expression) : Collections.emptySet();
        }
        return Collections.emptySet();
    }

    private static Set<String> keysFromDictionaryCreation(CallExpression callExpression) {
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol != null && "dict".equals(calleeSymbol.fullyQualifiedName())) {
            return callExpression.arguments().stream().filter(a -> a.is(Tree.Kind.REGULAR_ARGUMENT) && ((RegularArgument)a).keywordArgument() != null).map(a -> ((RegularArgument)a).keywordArgument().name()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Set<String> keysInDictionaryLiteral(DictionaryLiteral dictionaryLiteral) {
        return dictionaryLiteral.elements().stream().filter(e -> e.is(Tree.Kind.KEY_VALUE_PAIR)).map(kv -> ((KeyValuePair)kv).key()).filter(k -> k.is(Tree.Kind.STRING_LITERAL)).map(s -> ((StringLiteral)s).trimmedQuotesValue()).collect(Collectors.toSet());
    }

    private static boolean isException(FunctionSymbol functionSymbol) {
        return functionSymbol.hasDecorators() || DuplicateArgumentCheck.extendsZopeInterface(((FunctionSymbolImpl)functionSymbol).owner());
    }

    private static boolean extendsZopeInterface(@Nullable Symbol symbol) {
        if (symbol != null && symbol.is(Symbol.Kind.CLASS)) {
            return ((ClassSymbol)symbol).isOrExtends("zope.interface.Interface");
        }
        return false;
    }

    static LocationInFile locationFromTree(Tree tree, SubscriptionContext ctx) {
        PythonFile pythonFile = ctx.pythonFile();
        Path path = SymbolUtils.pathOf(pythonFile);
        String fileId = path != null ? path.toString() : pythonFile.toString();
        TokenLocation firstToken = new TokenLocation(tree.firstToken());
        TokenLocation lastToken = new TokenLocation(tree.lastToken());
        return new LocationInFile(fileId, firstToken.startLine(), firstToken.startLineOffset(), lastToken.endLine(), lastToken.endLineOffset());
    }
}

