/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S6730")
public class DeprecatedNumpyTypesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace this deprecated \"numpy\" type alias with the builtin type \"%s\".";
    private static final String QUICK_FIX_MESSAGE = "Replace with %s.";
    private static final Map<String, String> TYPE_TO_CHECK = Map.of("numpy.bool", "bool", "numpy.int", "int", "numpy.float", "float", "numpy.complex", "complex", "numpy.object", "object", "numpy.str", "str", "numpy.long", "int", "numpy.unicode", "str");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.QUALIFIED_EXPR, DeprecatedNumpyTypesCheck::checkForDeprecatedTypesNames);
    }

    private static void checkForDeprecatedTypesNames(SubscriptionContext ctx) {
        QualifiedExpression expression = (QualifiedExpression)ctx.syntaxNode();
        Optional.ofNullable(expression.symbol()).map(Symbol::fullyQualifiedName).map(TYPE_TO_CHECK::get).ifPresent(type -> DeprecatedNumpyTypesCheck.raiseIssue(expression, type, ctx));
    }

    private static void raiseIssue(Tree expression, String replacementType, SubscriptionContext ctx) {
        PythonCheck.PreciseIssue issue = ctx.addIssue(expression, String.format(MESSAGE, replacementType));
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix(String.format(QUICK_FIX_MESSAGE, replacementType), TextEditUtils.replace(expression, replacementType));
        issue.addQuickFix(quickFix);
    }
}

