/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7507")
public class DefaultFactoryArgumentCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder defaultDictTypeChecker = null;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.defaultDictTypeChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("collections.defaultdict");
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            if (this.defaultDictTypeChecker.check(callExpression.callee().typeV2()) != TriBool.TRUE) {
                return;
            }
            RegularArgument defaultFactoryKeywordArgument = TreeUtils.argumentByKeyword("default_factory", callExpression.arguments());
            if (defaultFactoryKeywordArgument != null) {
                ctx.addIssue(defaultFactoryKeywordArgument, "Replace this keyword argument with a positional argument at the first place.");
            }
        });
    }
}

