/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S2115")
public class DbNoPasswordCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add password protection to this database.";
    private static final List<String> CONNECT_METHODS = Arrays.asList("mysql.connector.connect", "mysql.connector.connection.MySQLConnection", "pymysql.connections.connect", "psycopg2.connect", "pgdb.connect.connect", "pg.DB", "pg.connect");
    private static final Pattern CONNECTION_URI_PATTERN = Pattern.compile("^(?:postgresql|mysql|oracle|mssql)(?:\\+.+?)?://.+?(:.*)?@.+");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, DbNoPasswordCheck::checkDbUri);
        context.registerSyntaxNodeConsumer(Tree.Kind.KEY_VALUE_PAIR, DbNoPasswordCheck::checkDjangoSettings);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, DbNoPasswordCheck::checkDbApi);
    }

    private static void checkDbUri(SubscriptionContext ctx) {
        String password;
        String value = ((StringLiteral)ctx.syntaxNode()).trimmedQuotesValue();
        Matcher matcher = CONNECTION_URI_PATTERN.matcher(value);
        if (matcher.find() && ((password = matcher.group(1)) == null || ":".equals(password))) {
            ctx.addIssue(ctx.syntaxNode(), MESSAGE);
        }
    }

    private static void checkDbApi(SubscriptionContext ctx) {
        RegularArgument passwordArgument;
        CallExpression callExpr = (CallExpression)ctx.syntaxNode();
        Symbol symbol = callExpr.calleeSymbol();
        if (symbol != null && CONNECT_METHODS.contains(symbol.fullyQualifiedName()) && (passwordArgument = DbNoPasswordCheck.getPasswordArgument(symbol.fullyQualifiedName(), callExpr.arguments())) != null && DbNoPasswordCheck.isString(passwordArgument.expression(), "")) {
            ctx.addIssue(passwordArgument, MESSAGE);
        }
    }

    private static RegularArgument getPasswordArgument(String method, List<Argument> arguments) {
        boolean isPg = method.startsWith("pg.");
        String argumentKeyword = isPg ? "passwd" : "password";
        int passwordIndex = isPg ? 5 : 2;
        int positionalIndex = 0;
        for (Argument argument : arguments) {
            if (!argument.is(Tree.Kind.REGULAR_ARGUMENT)) continue;
            RegularArgument regularArgument = (RegularArgument)argument;
            Name keyword = regularArgument.keywordArgument();
            if (keyword != null && keyword.name().equals(argumentKeyword)) {
                return regularArgument;
            }
            if (keyword != null) continue;
            if (positionalIndex == passwordIndex) {
                return regularArgument;
            }
            ++positionalIndex;
        }
        return null;
    }

    private static void checkDjangoSettings(SubscriptionContext ctx) {
        if (!"settings.py".equals(ctx.pythonFile().fileName())) {
            return;
        }
        KeyValuePair keyValue = (KeyValuePair)ctx.syntaxNode();
        Tree.Kind[] parentChain = new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL, Tree.Kind.KEY_VALUE_PAIR, Tree.Kind.DICTIONARY_LITERAL, Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.STATEMENT_LIST, Tree.Kind.FILE_INPUT};
        int index = 0;
        for (Tree currentParent = keyValue.parent(); currentParent != null && currentParent.is(parentChain[index]); currentParent = currentParent.parent()) {
            if (currentParent.is(Tree.Kind.ASSIGNMENT_STMT) && !DbNoPasswordCheck.isDatabasesAssignment((AssignmentStatement)currentParent)) {
                return;
            }
            ++index;
        }
        if (index == parentChain.length && keyValue.key().is(Tree.Kind.STRING_LITERAL) && DbNoPasswordCheck.isString(keyValue.key(), "PASSWORD") && DbNoPasswordCheck.isString(keyValue.value(), "")) {
            ctx.addIssue(keyValue, MESSAGE);
        }
    }

    private static boolean isString(Tree tree, String value) {
        if (tree.is(Tree.Kind.STRING_LITERAL)) {
            return ((StringLiteral)tree).trimmedQuotesValue().equals(value);
        }
        return false;
    }

    private static boolean isDatabasesAssignment(AssignmentStatement assignment) {
        List<ExpressionList> lhs = assignment.lhsExpressions();
        return lhs.size() == 1 && lhs.get(0).expressions().size() == 1 && lhs.get(0).expressions().get(0).is(Tree.Kind.NAME) && "DATABASES".equals(((Name)lhs.get(0).expressions().get(0)).name());
    }
}

