/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7514")
public class ControlFlowInTaskGroupCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Refactor the block to eliminate this \"%s\" statement.";
    private static final String SECONDARY_MESSAGE = "This is an async task group context.";
    private List<TypeCheckBuilder> taskGroupTypeChecks = new ArrayList<TypeCheckBuilder>();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.WITH_STMT, this::checkWithStatement);
    }

    private void setupTypeChecks(SubscriptionContext ctx) {
        this.taskGroupTypeChecks = new ArrayList<TypeCheckBuilder>();
        this.taskGroupTypeChecks.add(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("asyncio.TaskGroup"));
        this.taskGroupTypeChecks.add(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("trio.open_nursery"));
        this.taskGroupTypeChecks.add(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("anyio.create_task_group"));
    }

    private void checkWithStatement(SubscriptionContext ctx) {
        WithStatement withStatement = (WithStatement)ctx.syntaxNode();
        if (!withStatement.isAsync()) {
            return;
        }
        Optional<Expression> taskGroupItem = withStatement.withItems().stream().map(WithItem::test).filter(this::isTaskGroupOrNursery).findFirst();
        taskGroupItem.ifPresent(t -> {
            ControlFlowVisitor visitor = new ControlFlowVisitor(ctx, (Expression)t);
            withStatement.statements().accept(visitor);
        });
    }

    private boolean isTaskGroupOrNursery(Expression expression) {
        boolean result = this.taskGroupTypeChecks.stream().anyMatch(typeCheck -> typeCheck.check(expression.typeV2()) == TriBool.TRUE);
        if (!result && expression instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)expression;
            result = this.taskGroupTypeChecks.stream().anyMatch(typeCheck -> typeCheck.check(callExpression.callee().typeV2()) == TriBool.TRUE);
        }
        return result;
    }

    private static class ControlFlowVisitor
    extends BaseTreeVisitor {
        private final SubscriptionContext ctx;
        private final Expression taskGroupItem;

        public ControlFlowVisitor(SubscriptionContext ctx, Expression taskGroupItem) {
            this.ctx = ctx;
            this.taskGroupItem = taskGroupItem;
        }

        @Override
        public void visitReturnStatement(ReturnStatement returnStatement) {
            this.ctx.addIssue(returnStatement, String.format(ControlFlowInTaskGroupCheck.MESSAGE, "return")).secondary(this.taskGroupItem, ControlFlowInTaskGroupCheck.SECONDARY_MESSAGE);
        }

        @Override
        public void visitBreakStatement(BreakStatement breakStatement) {
            this.ctx.addIssue(breakStatement, String.format(ControlFlowInTaskGroupCheck.MESSAGE, "break")).secondary(this.taskGroupItem, ControlFlowInTaskGroupCheck.SECONDARY_MESSAGE);
        }

        @Override
        public void visitContinueStatement(ContinueStatement continueStatement) {
            this.ctx.addIssue(continueStatement, String.format(ControlFlowInTaskGroupCheck.MESSAGE, "continue")).secondary(this.taskGroupItem, ControlFlowInTaskGroupCheck.SECONDARY_MESSAGE);
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
        }
    }
}

