/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonVisitorCheck;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.cfg.fixpoint.ReachingDefinitionsAnalysis;
import org.sonar.python.checks.utils.CheckUtils;

@Rule(key="S5797")
public class ConstantConditionCheck
extends PythonVisitorCheck {
    private static final String MESSAGE = "Replace this expression; used as a condition it will always be constant.";
    private static final List<String> ACCEPTED_DECORATORS = List.of("overload", "staticmethod", "classmethod");
    private ReachingDefinitionsAnalysis reachingDefinitionsAnalysis;

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.reachingDefinitionsAnalysis = new ReachingDefinitionsAnalysis(this.getContext().pythonFile());
        super.visitFileInput(fileInput);
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) {
        this.checkConstantCondition(ifStatement.condition());
        this.scan(ifStatement.body());
        this.scan(ifStatement.elifBranches());
        this.scan(ifStatement.elseBranch());
    }

    @Override
    public void visitConditionalExpression(ConditionalExpression conditionalExpression) {
        this.checkConstantCondition(conditionalExpression.condition());
        super.visitConditionalExpression(conditionalExpression);
    }

    @Override
    public void visitComprehensionIf(ComprehensionIf comprehensionIf) {
        this.checkConstantCondition(comprehensionIf.condition());
        super.visitComprehensionIf(comprehensionIf);
    }

    private void checkConstantCondition(Expression condition) {
        Expression constantBooleanExpression = ConstantConditionCheck.getConstantBooleanExpression(condition);
        if (constantBooleanExpression != null) {
            this.addIssue(constantBooleanExpression, MESSAGE);
        }
        this.checkExpression(condition);
    }

    private static Expression getConstantBooleanExpression(Expression condition) {
        if (condition.is(Tree.Kind.AND, Tree.Kind.OR)) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            if (CheckUtils.isConstant(binaryExpression.leftOperand())) {
                return binaryExpression.leftOperand();
            }
            if (CheckUtils.isConstant(binaryExpression.rightOperand())) {
                return binaryExpression.rightOperand();
            }
        }
        if (condition.is(Tree.Kind.NOT) && CheckUtils.isConstant(((UnaryExpression)condition).expression())) {
            return ((UnaryExpression)condition).expression();
        }
        return null;
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        if (!binaryExpression.is(Tree.Kind.AND, Tree.Kind.OR)) {
            return;
        }
        if (CheckUtils.isConstant(binaryExpression.leftOperand())) {
            this.addIssue(binaryExpression.leftOperand(), MESSAGE);
            return;
        }
        if (binaryExpression.leftOperand().is(Tree.Kind.AND, Tree.Kind.OR)) {
            BinaryExpression leftOperand = (BinaryExpression)binaryExpression.leftOperand();
            this.checkExpression(leftOperand.leftOperand());
            if (!leftOperand.is(Tree.Kind.AND) || !binaryExpression.is(Tree.Kind.OR)) {
                this.checkExpression(leftOperand.rightOperand());
            }
            return;
        }
        if (binaryExpression.rightOperand().is(Tree.Kind.AND, Tree.Kind.OR)) {
            this.checkExpression(((BinaryExpression)binaryExpression.rightOperand()).leftOperand());
        }
    }

    private void checkExpression(Expression expression) {
        Expression lastAssignedValue;
        Set<Expression> valuesAtLocation;
        Symbol symbol;
        if (CheckUtils.isConstant(expression)) {
            this.addIssue(expression, MESSAGE);
            return;
        }
        if ((expression.is(Tree.Kind.NAME) || expression.is(Tree.Kind.QUALIFIED_EXPR)) && (symbol = ((HasSymbol)((Object)expression)).symbol()) != null && ConstantConditionCheck.isClassOrFunction(symbol)) {
            this.raiseIssueOnClassOrFunction(expression, symbol);
            return;
        }
        if (expression.is(Tree.Kind.NAME) && (valuesAtLocation = this.reachingDefinitionsAnalysis.valuesAtLocation((Name)expression)).size() == 1 && CheckUtils.isImmutableConstant(lastAssignedValue = valuesAtLocation.iterator().next())) {
            this.addIssue(expression, MESSAGE).secondary(lastAssignedValue, "Last assignment.");
        }
    }

    private void raiseIssueOnClassOrFunction(Expression expression, Symbol symbol) {
        PythonCheck.PreciseIssue issue = this.addIssue(expression, MESSAGE);
        LocationInFile locationInFile = ConstantConditionCheck.locationForClassOrFunction(symbol);
        if (locationInFile != null) {
            String type = symbol.is(Symbol.Kind.CLASS) ? "Class" : "Function";
            issue.secondary(locationInFile, String.format("%s definition.", type));
        }
    }

    private static boolean isClassOrFunction(Symbol symbol) {
        if (symbol.is(Symbol.Kind.CLASS)) {
            return true;
        }
        if (symbol.is(Symbol.Kind.FUNCTION)) {
            return ACCEPTED_DECORATORS.containsAll(((FunctionSymbol)symbol).decorators());
        }
        return false;
    }

    private static LocationInFile locationForClassOrFunction(Symbol symbol) {
        return symbol.is(Symbol.Kind.CLASS) ? ((ClassSymbol)symbol).definitionLocation() : ((FunctionSymbol)symbol).definitionLocation();
    }
}

