/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S7941")
public class CompressionModulesFromNamespaceCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Compression modules should be imported from the compression namespace.";
    private static final Set<String> COMPRESSION_MODULES = Set.of("lzma", "bz2", "gzip", "zlib");
    private boolean isPython314OrGreater = false;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeState);
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_FROM, this::checkImportFrom);
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, this::checkImportName);
    }

    private void initializeState(SubscriptionContext ctx) {
        this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan(ctx.sourcePythonVersions(), PythonVersionUtils.Version.V_314);
    }

    private void checkImportFrom(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        ImportFrom importFrom = (ImportFrom)ctx.syntaxNode();
        DottedName dottedModuleName = importFrom.module();
        CompressionModulesFromNamespaceCheck.raiseIfSingleNameCompressionModule(ctx, dottedModuleName);
    }

    private void checkImportName(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        ImportName importName = (ImportName)ctx.syntaxNode();
        for (AliasedName aliasedModuleName : importName.modules()) {
            DottedName dottedModuleName = aliasedModuleName.dottedName();
            CompressionModulesFromNamespaceCheck.raiseIfSingleNameCompressionModule(ctx, dottedModuleName);
        }
    }

    private static void raiseIfSingleNameCompressionModule(SubscriptionContext ctx, @Nullable DottedName moduleName) {
        if (moduleName != null && moduleName.names() != null && moduleName.names().size() == 1 && COMPRESSION_MODULES.contains(moduleName.names().get(0).name())) {
            ctx.addIssue(moduleName, MESSAGE);
        }
    }
}

