/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.IsComprehensionTransformedChecker;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7496")
public class CollectionCreationWrappedInConstructorCheck
extends PythonSubscriptionCheck {
    private static final String TUPLE = "tuple";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String DICT = "dict";
    private static final Set<String> COLLECTION_TYPES = Set.of("list", "set", "dict", "tuple");
    private static final Set<Tree.Kind> COLLECTION_KINDS = EnumSet.of(Tree.Kind.LIST_LITERAL, new Tree.Kind[]{Tree.Kind.SET_LITERAL, Tree.Kind.DICTIONARY_LITERAL, Tree.Kind.TUPLE, Tree.Kind.LIST_COMPREHENSION, Tree.Kind.SET_COMPREHENSION, Tree.Kind.DICT_COMPREHENSION});
    private static final Map<String, List<Tree.Kind>> SAME_INNER_TYPES_MAP = Map.of("list", List.of(Tree.Kind.LIST_LITERAL, Tree.Kind.LIST_COMPREHENSION), "set", List.of(Tree.Kind.SET_LITERAL, Tree.Kind.SET_COMPREHENSION), "dict", List.of(Tree.Kind.DICTIONARY_LITERAL, Tree.Kind.DICT_COMPREHENSION), "tuple", List.of(Tree.Kind.TUPLE));
    private final TypeCheckMap<String> collectionTypeCheckerMap = new TypeCheckMap();
    private IsComprehensionTransformedChecker isComprehensionTransformedChecker = null;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        this.isComprehensionTransformedChecker = new IsComprehensionTransformedChecker(context);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeCheckers);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCalls);
    }

    private void initializeTypeCheckers(SubscriptionContext ctx) {
        for (String collectionType : COLLECTION_TYPES) {
            TypeCheckBuilder typeChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(collectionType);
            this.collectionTypeCheckerMap.put(typeChecker, collectionType);
        }
    }

    private void checkCalls(SubscriptionContext ctx) {
        ComprehensionExpression comprehensionExpression;
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Expression callee = callExpression.callee();
        RegularArgument regularArgument = CollectionCreationWrappedInConstructorCheck.getSingleRegularArgument(callExpression);
        if (regularArgument == null) {
            return;
        }
        Expression expression = regularArgument.expression();
        if (expression instanceof ComprehensionExpression && !this.isComprehensionTransformedChecker.isGeneratorTransformingData(comprehensionExpression = (ComprehensionExpression)expression, callee.typeV2())) {
            return;
        }
        String collectionType = this.collectionTypeCheckerMap.getForType(callee.typeV2());
        if (collectionType == null || callee instanceof SubscriptionExpression) {
            return;
        }
        if (CollectionCreationWrappedInConstructorCheck.isSameInnerType(collectionType, regularArgument)) {
            ctx.addIssue(callExpression.callee(), CollectionCreationWrappedInConstructorCheck.getSameInnerTypeCollectionMessage(collectionType));
        } else if (CollectionCreationWrappedInConstructorCheck.isSensitiveDifferentLiteralInnerType(collectionType, regularArgument)) {
            ctx.addIssue(callExpression.callee(), CollectionCreationWrappedInConstructorCheck.getDifferentInnerTypeCollectionMessage(collectionType));
        } else if (collectionType.equals(TUPLE)) {
            CollectionCreationWrappedInConstructorCheck.handleTupleConstructorSpecialCases(ctx, regularArgument);
        }
    }

    private static RegularArgument getSingleRegularArgument(CallExpression callExpression) {
        if (callExpression.arguments().size() != 1) {
            return null;
        }
        Argument argument = callExpression.arguments().get(0);
        if (!(argument instanceof RegularArgument)) {
            return null;
        }
        RegularArgument regularArgument = (RegularArgument)argument;
        return regularArgument;
    }

    private static boolean isSameInnerType(String collectionType, RegularArgument regularArgument) {
        return SAME_INNER_TYPES_MAP.get(collectionType).stream().anyMatch(kind -> regularArgument.expression().is((Tree.Kind)((Object)kind)));
    }

    private static boolean isSensitiveDifferentLiteralInnerType(String collectionType, RegularArgument regularArgument) {
        if (!CollectionCreationWrappedInConstructorCheck.isCollectionKind(regularArgument)) {
            return false;
        }
        if (CollectionCreationWrappedInConstructorCheck.isSameInnerType(collectionType, regularArgument)) {
            return false;
        }
        if (regularArgument.expression().is(Tree.Kind.SET_COMPREHENSION)) {
            return false;
        }
        EnumSet<Tree.Kind> comprehensions = EnumSet.of(Tree.Kind.LIST_COMPREHENSION, Tree.Kind.SET_COMPREHENSION, Tree.Kind.DICT_COMPREHENSION);
        return !collectionType.equals(TUPLE) || !comprehensions.contains((Object)regularArgument.expression().getKind());
    }

    private static String getSameInnerTypeCollectionMessage(String type) {
        return "Remove the redundant " + type + " constructor call.";
    }

    private static String getDifferentInnerTypeCollectionMessage(String type) {
        return "Replace this " + type + " constructor call by a " + type + " literal.";
    }

    private static void handleTupleConstructorSpecialCases(SubscriptionContext ctx, RegularArgument regularArgument) {
        if (regularArgument.expression().is(Tree.Kind.LIST_COMPREHENSION)) {
            ctx.addIssue(regularArgument, "Replace this list comprehension by a generator.");
        } else if (regularArgument.expression().is(Tree.Kind.SET_COMPREHENSION)) {
            ctx.addIssue(regularArgument, "Replace this set comprehension by a generator.");
        } else if (regularArgument.expression().is(Tree.Kind.DICT_COMPREHENSION)) {
            ctx.addIssue(regularArgument, "Replace this dict comprehension by a generator.");
        }
    }

    private static boolean isCollectionKind(RegularArgument regularArgument) {
        return COLLECTION_KINDS.contains((Object)regularArgument.expression().getKind());
    }
}

