/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.SymbolUtils;

@Rule(key="S2638")
public class ChangeMethodContractCheck
extends PythonSubscriptionCheck {
    private static final Set<String> IGNORING_DECORATORS = Set.of("abc.abstractmethod", "abstractmethod", "overload", "typing.overload");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            String functionName = functionDef.name().name();
            if (functionName.startsWith("__") && functionName.endsWith("__")) {
                return;
            }
            Symbol symbol = functionDef.name().symbol();
            if (symbol == null || symbol.kind() != Symbol.Kind.FUNCTION) {
                return;
            }
            FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
            if (functionSymbol.hasVariadicParameter() || functionSymbol.hasDecorators()) {
                return;
            }
            ChangeMethodContractCheck.checkMethodContract(ctx, functionSymbol);
        });
    }

    private static void checkMethodContract(SubscriptionContext ctx, FunctionSymbol method) {
        List<FunctionSymbol> potentialSymbols = SymbolUtils.getOverriddenMethods(method);
        SymbolUtils.getFirstAlternativeIfEqualArgumentNames(potentialSymbols).ifPresent(overriddenMethod -> {
            if (overriddenMethod.hasVariadicParameter() || ChangeMethodContractCheck.hasDecorators(overriddenMethod)) {
                return;
            }
            int paramsDiff = method.parameters().size() - overriddenMethod.parameters().size();
            if (paramsDiff != 0 && overriddenMethod.parameters().stream().anyMatch(FunctionSymbol.Parameter::isKeywordOnly)) {
                ChangeMethodContractCheck.reportIssue(ctx, "Change this method signature to accept the same arguments as the method it overrides.", method.definitionLocation(), overriddenMethod);
                return;
            }
            if (paramsDiff > 0) {
                ChangeMethodContractCheck.reportOnExtraParameters(ctx, method, overriddenMethod);
            } else if (paramsDiff < 0) {
                ChangeMethodContractCheck.reportOnMissingParameters(ctx, method, overriddenMethod);
            } else {
                ChangeMethodContractCheck.checkDefaultValuesAndParamNames(ctx, method, overriddenMethod);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasDecorators(FunctionSymbol symbol) {
        if (!symbol.hasDecorators()) return false;
        if (!symbol.decorators().stream().anyMatch(Predicate.not(IGNORING_DECORATORS::contains))) return false;
        return true;
    }

    private static void reportOnMissingParameters(SubscriptionContext ctx, FunctionSymbol method, FunctionSymbol overriddenMethod) {
        int indexFirstMissingParam = method.parameters().size();
        List<FunctionSymbol.Parameter> overriddenParams = overriddenMethod.parameters();
        List<String> missingParameters = overriddenParams.subList(indexFirstMissingParam, overriddenParams.size()).stream().map(FunctionSymbol.Parameter::name).toList();
        if (!missingParameters.isEmpty()) {
            ChangeMethodContractCheck.reportIssue(ctx, ChangeMethodContractCheck.getMissingParametersMessage(missingParameters), method.definitionLocation(), overriddenMethod);
        }
    }

    private static String getMissingParametersMessage(List<String> missingParameters) {
        if (missingParameters.contains(null)) {
            return missingParameters.size() == 1 ? "Add 1 missing parameter." : "Add " + missingParameters.size() + " missing parameters.";
        }
        return "Add missing parameters " + String.join((CharSequence)" ", missingParameters).trim() + ".";
    }

    private static void reportIssue(SubscriptionContext ctx, String message, @Nullable LocationInFile location, FunctionSymbol overriddenMethod) {
        Optional.ofNullable(location).ifPresent(issueLocation -> {
            LocationInFile secondaryLocation = overriddenMethod.definitionLocation();
            if (secondaryLocation != null) {
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((LocationInFile)issueLocation, message);
                preciseIssue.secondary(secondaryLocation, "Overridden method's definition");
            } else {
                ctx.addIssue((LocationInFile)issueLocation, message + " This method overrides " + overriddenMethod.fullyQualifiedName() + ".");
            }
        });
    }

    private static void reportOnExtraParameters(SubscriptionContext ctx, FunctionSymbol method, FunctionSymbol overriddenMethod) {
        long paramsWithoutDefaultValue = method.parameters().stream().filter(parameter -> !parameter.hasDefaultValue()).count();
        if (paramsWithoutDefaultValue == (long)overriddenMethod.parameters().size()) {
            return;
        }
        method.parameters().stream().filter(parameter -> !parameter.hasDefaultValue() && parameter.name() != null).filter(parameter -> overriddenMethod.parameters().stream().noneMatch(p -> Objects.equals(parameter.name(), p.name()))).forEach(parameter -> ChangeMethodContractCheck.reportIssue(ctx, "Remove parameter " + parameter.name() + " or provide default value.", parameter.location(), overriddenMethod));
    }

    private static void checkDefaultValuesAndParamNames(SubscriptionContext ctx, FunctionSymbol method, FunctionSymbol overriddenMethod) {
        HashMap<String, Integer> mismatchedOverriddenParamPosition = new HashMap<String, Integer>();
        HashMap<String, Integer> mismatchedParamPosition = new HashMap<String, Integer>();
        List<FunctionSymbol.Parameter> parameters = method.parameters();
        for (int i = 0; i < overriddenMethod.parameters().size(); ++i) {
            FunctionSymbol.Parameter overriddenParam = overriddenMethod.parameters().get(i);
            FunctionSymbol.Parameter parameter = method.parameters().get(i);
            if (!Objects.equals(overriddenParam.name(), parameter.name())) {
                mismatchedOverriddenParamPosition.put(overriddenParam.name(), i);
                mismatchedParamPosition.put(parameter.name(), i);
                continue;
            }
            ChangeMethodContractCheck.checkDefaultValueAndKeywordOnly(ctx, overriddenMethod, overriddenParam, parameter);
        }
        mismatchedParamPosition.forEach((name, index) -> {
            Integer overriddenParamIndex = (Integer)mismatchedOverriddenParamPosition.get(name);
            FunctionSymbol.Parameter parameter = (FunctionSymbol.Parameter)parameters.get((int)index);
            if (overriddenParamIndex != null && !parameter.isKeywordOnly()) {
                ChangeMethodContractCheck.reportIssue(ctx, "Move parameter " + name + " to position " + overriddenParamIndex + ".", parameter.location(), overriddenMethod);
            }
        });
    }

    private static void checkDefaultValueAndKeywordOnly(SubscriptionContext ctx, FunctionSymbol overriddenMethod, FunctionSymbol.Parameter overriddenParam, FunctionSymbol.Parameter parameter) {
        String prefix = "Make parameter " + parameter.name();
        if (overriddenParam.hasDefaultValue() && !parameter.hasDefaultValue()) {
            ChangeMethodContractCheck.reportIssue(ctx, "Add a default value to parameter " + parameter.name() + ".", parameter.location(), overriddenMethod);
        }
        if (!overriddenParam.isKeywordOnly() && !overriddenParam.isPositionalOnly() && (parameter.isKeywordOnly() || parameter.isPositionalOnly())) {
            ChangeMethodContractCheck.reportIssue(ctx, prefix + " keyword-or-positional.", parameter.location(), overriddenMethod);
        }
        if (overriddenParam.isKeywordOnly() && !parameter.isKeywordOnly()) {
            ChangeMethodContractCheck.reportIssue(ctx, prefix + " keyword only.", parameter.location(), overriddenMethod);
        }
    }
}

