/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S6545")
public class BuiltinGenericsOverTypingModuleCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Use the built-in generic type `%s` instead of its typing counterpart.";
    private static final Map<String, String> GENERICS_NAME = Map.ofEntries(Map.entry("typing.List", "list"), Map.entry("typing.Dict", "dict"), Map.entry("typing.Tuple", "tuple"), Map.entry("typing.Set", "set"), Map.entry("typing.FrozenSet", "frozenset"), Map.entry("typing.Type", "type"), Map.entry("typing.Iterable", "collections.abc.Iterable"), Map.entry("typing.AbstractSet", "collections.abc.Set"), Map.entry("typing.Callable", "collections.abc.Callable"), Map.entry("typing.Mapping", "collections.abc.Mapping"), Map.entry("typing.Sequence", "collections.abc.Sequence"), Map.entry("typing.deque", "collections.deque"), Map.entry("typing.defaultdict", "collections.defaultdict"), Map.entry("typing.OrderedDict", "collections.OrderedDict"), Map.entry("typing.Counter", "collections.Counter"), Map.entry("typing.ChainMap", "collections.ChainMap"));

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_TYPE_ANNOTATION, BuiltinGenericsOverTypingModuleCheck::checkForTypingModule);
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER_TYPE_ANNOTATION, BuiltinGenericsOverTypingModuleCheck::checkForTypingModule);
        context.registerSyntaxNodeConsumer(Tree.Kind.VARIABLE_TYPE_ANNOTATION, BuiltinGenericsOverTypingModuleCheck::checkForTypingModule);
    }

    private static void checkForTypingModule(SubscriptionContext subscriptionContext) {
        TypeAnnotation typeAnnotation = (TypeAnnotation)subscriptionContext.syntaxNode();
        Expression expression = typeAnnotation.expression();
        BuiltinGenericsOverTypingModuleCheck.checkForGenericsFromTypingModule(subscriptionContext, expression);
    }

    private static void checkForGenericsFromTypingModule(SubscriptionContext subscriptionContext, Expression expression) {
        if (expression instanceof SubscriptionExpression) {
            SubscriptionExpression subscriptionExpression = (SubscriptionExpression)expression;
            BuiltinGenericsOverTypingModuleCheck.getGenericsCounterPartFromTypingModule(subscriptionContext, subscriptionExpression).ifPresent(preferredGenerics -> BuiltinGenericsOverTypingModuleCheck.raiseIssueForGenerics(subscriptionContext, subscriptionExpression, preferredGenerics));
        }
    }

    private static void raiseIssueForGenerics(SubscriptionContext context, SubscriptionExpression expression, String preferredGenerics) {
        String specificMessage = String.format(MESSAGE, preferredGenerics);
        PythonCheck.PreciseIssue preciseIssue = context.addIssue(expression, specificMessage);
        BuiltinGenericsOverTypingModuleCheck.addQuickFix(preciseIssue, expression, preferredGenerics, specificMessage);
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, SubscriptionExpression expression, String preferredGenerics, String message) {
        if (!preferredGenerics.contains(".")) {
            PythonQuickFix quickFix = PythonQuickFix.newQuickFix(message).addTextEdit(TextEditUtils.replaceRange(expression.firstToken(), expression.leftBracket(), preferredGenerics + "[")).build();
            issue.addQuickFix(quickFix);
        }
    }

    private static Optional<String> getGenericsCounterPartFromTypingModule(SubscriptionContext context, SubscriptionExpression expression) {
        expression.subscripts().expressions().forEach(nestedExpression -> BuiltinGenericsOverTypingModuleCheck.checkForGenericsFromTypingModule(context, nestedExpression));
        return Optional.of(expression.object()).map(HasSymbol.class::cast).map(HasSymbol::symbol).flatMap(BuiltinGenericsOverTypingModuleCheck::getBuiltinGenericsType);
    }

    private static Optional<String> getBuiltinGenericsType(@Nullable Symbol maybeSymbol) {
        return Optional.ofNullable(maybeSymbol).map(Symbol::fullyQualifiedName).flatMap(fullyQualifiedName -> Optional.ofNullable(GENERICS_NAME.get(fullyQualifiedName)));
    }
}

