/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.InExpression;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1940")
public class BooleanCheckNotInvertedCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use the opposite operator (\"%s\") instead.";
    private static final Set<String> EQUALITY_COMPARATORS = Set.of("==", "!=");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.NOT, ctx -> BooleanCheckNotInvertedCheck.checkNotExpression(ctx, (UnaryExpression)ctx.syntaxNode()));
    }

    private static void checkNotExpression(SubscriptionContext ctx, UnaryExpression original) {
        Expression negatedExpr = original.expression();
        while (negatedExpr.is(Tree.Kind.PARENTHESIZED)) {
            negatedExpr = ((ParenthesizedExpression)negatedExpr).expression();
        }
        if (negatedExpr.is(Tree.Kind.COMPARISON)) {
            BinaryExpression binaryExp = (BinaryExpression)negatedExpr;
            if (!binaryExp.leftOperand().is(Tree.Kind.COMPARISON)) {
                if (BooleanCheckNotInvertedCheck.isSetComparison(binaryExp) && !EQUALITY_COMPARATORS.contains(binaryExp.operator().value())) {
                    return;
                }
                String oppositeOperator = BooleanCheckNotInvertedCheck.oppositeOperator(binaryExp.operator());
                PythonCheck.PreciseIssue issue = ctx.addIssue(original, String.format(MESSAGE, oppositeOperator));
                BooleanCheckNotInvertedCheck.createQuickFix(issue, oppositeOperator, binaryExp, original);
            }
        } else if (negatedExpr.is(Tree.Kind.IN, Tree.Kind.IS)) {
            BinaryExpression isInExpr = (BinaryExpression)negatedExpr;
            String oppositeOperator = BooleanCheckNotInvertedCheck.oppositeOperator(isInExpr.operator(), isInExpr);
            PythonCheck.PreciseIssue issue = ctx.addIssue(original, String.format(MESSAGE, oppositeOperator));
            BooleanCheckNotInvertedCheck.createQuickFix(issue, oppositeOperator, isInExpr, original);
        }
    }

    private static String oppositeOperator(Token operator) {
        return BooleanCheckNotInvertedCheck.oppositeOperatorString(operator.value());
    }

    private static String oppositeOperator(Token operator, Expression expr) {
        Object s = operator.value();
        if (expr.is(Tree.Kind.IS) && ((IsExpression)expr).notToken() != null) {
            s = (String)s + " not";
        } else if (expr.is(Tree.Kind.IN) && ((InExpression)expr).notToken() != null) {
            s = "not " + (String)s;
        }
        return BooleanCheckNotInvertedCheck.oppositeOperatorString((String)s);
    }

    static String oppositeOperatorString(String stringOperator) {
        switch (stringOperator) {
            case ">": {
                return "<=";
            }
            case ">=": {
                return "<";
            }
            case "<": {
                return ">=";
            }
            case "<=": {
                return ">";
            }
            case "==": {
                return "!=";
            }
            case "!=": {
                return "==";
            }
            case "is": {
                return "is not";
            }
            case "is not": {
                return "is";
            }
            case "in": {
                return "not in";
            }
            case "not in": {
                return "in";
            }
        }
        throw new IllegalArgumentException("Unknown comparison operator : " + stringOperator);
    }

    private static void createQuickFix(PythonCheck.PreciseIssue issue, String oppositeOperator, BinaryExpression toUse, UnaryExpression notAncestor) {
        PythonTextEdit replaceEdit = BooleanCheckNotInvertedCheck.getReplaceEdit(toUse, oppositeOperator, notAncestor);
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix(String.format("Use %s instead", oppositeOperator)).addTextEdit(replaceEdit).build();
        issue.addQuickFix(quickFix);
    }

    private static PythonTextEdit getReplaceEdit(BinaryExpression toUse, String oppositeOperator, UnaryExpression notAncestor) {
        return TextEditUtils.replace(notAncestor, BooleanCheckNotInvertedCheck.getNewExpression(toUse, oppositeOperator));
    }

    private static String getNewExpression(BinaryExpression toUse, String oppositeOperator) {
        return BooleanCheckNotInvertedCheck.getText(toUse.leftOperand()) + " " + oppositeOperator + " " + BooleanCheckNotInvertedCheck.getText(toUse.rightOperand());
    }

    private static String getText(Tree defaultValue) {
        List<Token> tokens = TreeUtils.tokens(defaultValue);
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (i > 0) {
                Token previous = tokens.get(i - 1);
                int linesBetween = token.line() - previous.line();
                int spacesBetween = linesBetween == 0 ? token.column() - previous.column() - previous.value().length() : token.column();
                valueBuilder.append("\n".repeat(linesBetween));
                valueBuilder.append(" ".repeat(spacesBetween));
            }
            valueBuilder.append(token.value());
        }
        return valueBuilder.toString();
    }

    private static boolean isSetComparison(BinaryExpression binaryExpression) {
        List<InferredType> inferredTypeSet = List.of(binaryExpression.leftOperand().type(), binaryExpression.rightOperand().type());
        return inferredTypeSet.stream().anyMatch(inferredType -> inferredType.mustBeOrExtend("set"));
    }
}

