/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.python.checks.utils.AwsLambdaChecksUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7621")
public class AwsWaitersInsteadOfCustomPollingCheck
extends PythonSubscriptionCheck {
    private static final Set<String> NON_WAITERS_BOTO3_METHODS = Set.of("botocore.client.BaseClient.describe_instances", "botocore.client.BaseClient.describe_instance_status", "botocore.client.BaseClient.describe_volumes", "botocore.client.BaseClient.describe_snapshots", "botocore.client.BaseClient.describe_images", "botocore.client.BaseClient.describe_vpcs", "botocore.client.BaseClient.describe_subnets", "botocore.client.BaseClient.describe_nat_gateways", "botocore.client.BaseClient.describe_key_pairs", "botocore.client.BaseClient.get_password_data", "botocore.client.BaseClient.head_bucket", "botocore.client.BaseClient.head_object", "botocore.client.BaseClient.describe_db_instances", "botocore.client.BaseClient.describe_db_clusters", "botocore.client.BaseClient.describe_db_snapshots", "botocore.client.BaseClient.describe_table", "botocore.client.BaseClient.describe_services", "botocore.client.BaseClient.describe_tasks", "botocore.client.BaseClient.describe_cluster", "botocore.client.BaseClient.describe_nodegroup", "botocore.client.BaseClient.describe_stacks", "botocore.client.BaseClient.describe_change_set", "botocore.client.BaseClient.get_function_configuration", "botocore.client.BaseClient.get_function");
    private final TypeCheckMap<Boolean> nonWaitersBoto3MethodsTypeCheckMap = new TypeCheckMap();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initializeCheck(SubscriptionContext ctx) {
        NON_WAITERS_BOTO3_METHODS.stream().map(fqn -> ctx.typeChecker().typeCheckBuilder().isTypeWithFqn((String)fqn)).forEach(check -> this.nonWaitersBoto3MethodsTypeCheckMap.put((TypeCheckBuilder)check, true));
    }

    private void check(SubscriptionContext ctx) {
        FunctionDef functionDef;
        WhileStatement whileStatement;
        Tree tree;
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (this.nonWaitersBoto3MethodsTypeCheckMap.containsForType(TreeUtils.inferSingleAssignedExpressionType(callExpression.callee())) && (tree = TreeUtils.firstAncestorOfKind(callExpression, Tree.Kind.WHILE_STMT)) instanceof WhileStatement && Expressions.isTruthy((whileStatement = (WhileStatement)tree).condition()) && (tree = TreeUtils.firstAncestorOfKind(callExpression, Tree.Kind.FUNCDEF)) instanceof FunctionDef && AwsLambdaChecksUtils.isLambdaHandler(ctx, functionDef = (FunctionDef)tree)) {
            ctx.addIssue(callExpression, "Use AWS waiters instead of custom polling loops.");
        }
    }
}

