/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7625")
public class AwsLongTermAccessKeysCheck
extends PythonSubscriptionCheck {
    private static final String ACCESS_KEY_MESSAGE = "Make sure using long-term access keys is safe here.";
    private static final String SECRET_KEY_MESSAGE = "Make sure using long-term secret keys is safe here.";
    private static final Set<ClientMethod> AWS_CLIENT_METHODS = Set.of(new ClientMethod("boto3.client", 6), new ClientMethod("boto3.resource", 6), new ClientMethod("boto3.session.Session.client", 6), new ClientMethod("boto3.session.Session.resource", 6), new ClientMethod("boto3.session.Session", 0));
    private TypeCheckMap<ClientMethod> awsClientTypeChecks;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeCheckMap);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void initializeTypeCheckMap(SubscriptionContext ctx) {
        this.awsClientTypeChecks = new TypeCheckMap();
        AWS_CLIENT_METHODS.forEach(clientMethod -> this.awsClientTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName(clientMethod.fqn()), (ClientMethod)clientMethod));
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        CallExpression call = (CallExpression)ctx.syntaxNode();
        ClientMethod clientMethod = this.awsClientTypeChecks.getForType(call.callee().typeV2());
        if (clientMethod != null) {
            RegularArgument accessKeyArgument = AwsLongTermAccessKeysCheck.getAccessKeyArgument(clientMethod, call);
            RegularArgument secretKeyArgument = AwsLongTermAccessKeysCheck.getSecretKeyArgument(clientMethod, call);
            if (accessKeyArgument != null && AwsLongTermAccessKeysCheck.isLongTermKeyPassedAsArgument(accessKeyArgument)) {
                ctx.addIssue(accessKeyArgument, ACCESS_KEY_MESSAGE);
            } else if (secretKeyArgument != null && AwsLongTermAccessKeysCheck.isLongTermKeyPassedAsArgument(secretKeyArgument)) {
                ctx.addIssue(secretKeyArgument, SECRET_KEY_MESSAGE);
            }
        }
    }

    private static RegularArgument getSecretKeyArgument(ClientMethod clientMethod, CallExpression call) {
        return TreeUtils.nthArgumentOrKeyword(clientMethod.awsSecretAccessKeyArgIndex(), "aws_secret_access_key", call.arguments());
    }

    private static RegularArgument getAccessKeyArgument(ClientMethod clientMethod, CallExpression call) {
        return TreeUtils.nthArgumentOrKeyword(clientMethod.awsAccessKeyIdArgIndex(), "aws_access_key_id", call.arguments());
    }

    private static boolean isLongTermKeyPassedAsArgument(RegularArgument argument) {
        Expression expression = argument.expression();
        return AwsLongTermAccessKeysCheck.isStringLiteral(expression) || AwsLongTermAccessKeysCheck.isAssignedValueString(expression);
    }

    private static boolean isAssignedValueString(Expression expression) {
        if (expression instanceof Name) {
            Name name = (Name)expression;
            Expression assignedValue = Expressions.singleAssignedValue(name);
            return assignedValue != null && AwsLongTermAccessKeysCheck.isStringLiteral(assignedValue);
        }
        return false;
    }

    private static boolean isStringLiteral(Expression expr) {
        return expr.is(Tree.Kind.STRING_LITERAL);
    }

    record ClientMethod(String fqn, int awsAccessKeyIdArgIndex) {
        public int awsSecretAccessKeyArgIndex() {
            return this.awsAccessKeyIdArgIndex + 1;
        }
    }
}

