/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.utils.AwsLambdaChecksUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7613")
public class AwsLambdaReturnValueAreSerializableCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Fix the return value to be JSON serializable.";
    private static final String SECONDARY_LOCATION_MESSAGE = "The non-serializable value is set here.";
    private static final Set<String> NON_SERIALIZABLE_FQNS = Set.of("datetime.datetime.now", "datetime.datetime.utcnow", "datetime.datetime.today", "datetime.datetime.fromtimestamp", "datetime.datetime.utcfromtimestamp", "datetime.date", "datetime.date.today", "datetime.date.fromtimestamp", "datetime.time");
    private static final Set<String> SERIALIZATION_METHOD_NAMES = Set.of("to_dict", "dict", "asdict", "serialize", "json");
    private TypeCheckBuilder listType;
    private TypeCheckBuilder setType;
    private TypeCheckMap<Object> serializationFunctions;
    private TypeCheckMap<Object> nonSerializableTypes;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeTypeChecker);
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_STMT, this::checkReturnStatement);
    }

    private void initializeTypeChecker(SubscriptionContext ctx) {
        this.listType = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("list");
        this.setType = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("set");
        Object object = new Object();
        this.serializationFunctions = new TypeCheckMap();
        this.serializationFunctions.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("dataclasses.asdict"), object);
        this.serializationFunctions.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("json.dumps"), object);
        this.serializationFunctions.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("json.loads"), object);
        this.nonSerializableTypes = new TypeCheckMap();
        this.nonSerializableTypes.put(this.setType, object);
        this.nonSerializableTypes.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("re.Pattern"), object);
        this.nonSerializableTypes.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("decimal.Decimal"), object);
        this.nonSerializableTypes.put(ctx.typeChecker().typeCheckBuilder().isInstanceOf("typing.IO"), object);
        this.nonSerializableTypes.put(ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("complex"), object);
        this.nonSerializableTypes.put(ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("bytes"), object);
        this.nonSerializableTypes.put(ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("bytearray"), object);
        this.nonSerializableTypes.put(ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("frozenset"), object);
    }

    private void checkReturnStatement(SubscriptionContext ctx) {
        ReturnStatement returnStmt = (ReturnStatement)ctx.syntaxNode();
        Tree parentFunction = TreeUtils.firstAncestorOfKind(returnStmt, Tree.Kind.FUNCDEF);
        if (parentFunction == null) {
            return;
        }
        FunctionDef function = (FunctionDef)parentFunction;
        if (!AwsLambdaChecksUtils.isOnlyLambdaHandler(ctx, function)) {
            return;
        }
        if (returnStmt.expressions().isEmpty()) {
            return;
        }
        Expression returnExpr = returnStmt.expressions().get(0);
        this.getNonSerializableExpr(returnExpr).forEach(location -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue(location.mainLocation, MESSAGE);
            location.secondaryLocation.ifPresent(secondaryLocation -> issue.secondary((Tree)secondaryLocation, SECONDARY_LOCATION_MESSAGE));
        });
    }

    private Stream<IssueLocation> getNonSerializableExpr(Expression expr) {
        switch (expr.getKind()) {
            case CALL_EXPR: {
                return this.getNonSerializableCallExpr((CallExpression)expr);
            }
            case DICTIONARY_LITERAL: {
                return this.getNonSerializableInDictionaryLiteral((DictionaryLiteral)expr);
            }
            case LIST_LITERAL: {
                return this.getNonSerializableInListLiteral((ListLiteral)expr);
            }
            case TUPLE: {
                return this.getNonSerializableInTuple((Tuple)expr);
            }
            case NAME: {
                return this.getNonSerializableFromName((Name)expr);
            }
        }
        return this.getNonSerializableFromTypeOrFqn(expr);
    }

    private Stream<IssueLocation> getNonSerializableCallExpr(CallExpression callExpr) {
        String fullyQualifiedName;
        if (AwsLambdaReturnValueAreSerializableCheck.isSerializationMethodCall(callExpr)) {
            return Stream.of(new IssueLocation[0]);
        }
        Symbol calleeSymbol = callExpr.calleeSymbol();
        String string = fullyQualifiedName = calleeSymbol != null ? calleeSymbol.fullyQualifiedName() : null;
        if (fullyQualifiedName == null) {
            return Stream.of(new IssueLocation[0]);
        }
        if (this.listType.check(callExpr.callee().typeV2()).equals((Object)TriBool.TRUE)) {
            return callExpr.arguments().stream().flatMap(TreeUtils.toStreamInstanceOfMapper(RegularArgument.class)).map(RegularArgument::expression).filter(argExpr -> !this.isSet((Expression)argExpr)).flatMap(this::getNonSerializableExpr);
        }
        if (this.serializationFunctions.getOptionalForType(callExpr.callee().typeV2()).isPresent()) {
            Stream.of(new Object[0]);
        }
        if (this.nonSerializableTypes.getOptionalForType(callExpr.typeV2()).isPresent() || NON_SERIALIZABLE_FQNS.contains(fullyQualifiedName) || AwsLambdaReturnValueAreSerializableCheck.isUserDefinedClassWithoutSerializationMethods(calleeSymbol)) {
            return Stream.of(new IssueLocation(callExpr));
        }
        return Stream.of(new IssueLocation[0]);
    }

    private static boolean isSerializationMethodCall(CallExpression callExpr) {
        if (callExpr.callee().is(Tree.Kind.QUALIFIED_EXPR)) {
            QualifiedExpression qualifiedExpr = (QualifiedExpression)callExpr.callee();
            String methodName = qualifiedExpr.name().name();
            return SERIALIZATION_METHOD_NAMES.contains(methodName);
        }
        return false;
    }

    private static boolean isUserDefinedClassWithoutSerializationMethods(Symbol symbol) {
        return symbol.usages().stream().filter(usage -> usage.kind() == Usage.Kind.CLASS_DECLARATION).map(Usage::tree).findFirst().flatMap(TreeUtils::getSymbolFromTree).filter(ClassSymbol.class::isInstance).map(ClassSymbol.class::cast).map(classSymbol -> !classSymbol.canHaveMember("__dict__") && !classSymbol.canHaveMember("__json__")).orElse(false);
    }

    private Stream<IssueLocation> getNonSerializableInDictionaryLiteral(DictionaryLiteral dictLiteral) {
        return dictLiteral.elements().stream().flatMap(TreeUtils.toStreamInstanceOfMapper(KeyValuePair.class)).flatMap(kvPair -> Stream.concat(this.getNonSerializableExpr(kvPair.key()), this.getNonSerializableExpr(kvPair.value())));
    }

    private Stream<IssueLocation> getNonSerializableInListLiteral(ListLiteral listLiteral) {
        return listLiteral.elements().expressions().stream().flatMap(this::getNonSerializableExpr);
    }

    private Stream<IssueLocation> getNonSerializableInTuple(Tuple tuple) {
        return tuple.elements().stream().flatMap(this::getNonSerializableExpr);
    }

    private Stream<IssueLocation> getNonSerializableFromName(Name name) {
        Expression assignedValue = Expressions.singleAssignedValue(name);
        if (assignedValue == null) {
            return AwsLambdaReturnValueAreSerializableCheck.getNonSerializableFromFuncDef(name);
        }
        return this.getNonSerializableExpr(assignedValue).map(assignedValueLocation -> new IssueLocation(name, Optional.of(assignedValueLocation.mainLocation)));
    }

    private static Stream<IssueLocation> getNonSerializableFromFuncDef(Name name) {
        return TreeUtils.getSymbolFromTree(name).stream().flatMap(symbol -> symbol.usages().stream()).filter(usage -> usage.kind() == Usage.Kind.FUNC_DECLARATION).findFirst().map(usage -> new IssueLocation(name)).stream();
    }

    private boolean isSet(Expression expr) {
        return this.setType.check(expr.typeV2()) == TriBool.TRUE;
    }

    private Stream<IssueLocation> getNonSerializableFromTypeOrFqn(Expression expr) {
        if (this.nonSerializableTypes.getOptionalForType(expr.typeV2()).isPresent()) {
            return Stream.of(new IssueLocation(expr));
        }
        return TreeUtils.getSymbolFromTree(expr).map(Symbol::fullyQualifiedName).filter(NON_SERIALIZABLE_FQNS::contains).map(fqn -> new IssueLocation(expr)).stream();
    }

    record IssueLocation(Tree mainLocation, Optional<Tree> secondaryLocation) {
        public IssueLocation(Tree mainLocation) {
            this(mainLocation, Optional.empty());
        }
    }
}

