/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.AwsLambdaChecksUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7617")
public class AwsLambdaReservedEnvironmentVariableCheck
extends PythonSubscriptionCheck {
    private static final Set<String> AWS_RESERVED_ENVIRONMENT_VARIABLES = Set.of("_HANDLER", "_X_AMZN_TRACE_ID", "AWS_DEFAULT_REGION", "AWS_REGION", "AWS_EXECUTION_ENV", "AWS_LAMBDA_FUNCTION_NAME", "AWS_LAMBDA_FUNCTION_MEMORY_SIZE", "AWS_LAMBDA_FUNCTION_VERSION", "AWS_LAMBDA_INITIALIZATION_TYPE", "AWS_LAMBDA_LOG_GROUP_NAME", "AWS_LAMBDA_LOG_STREAM_NAME", "AWS_ACCESS_KEY", "AWS_ACCESS_KEY_ID", "AWS_SECRET_ACCESS_KEY", "AWS_SESSION_TOKEN", "AWS_LAMBDA_RUNTIME_API", "LAMBDA_TASK_ROOT", "LAMBDA_RUNTIME_DIR");
    private TypeCheckBuilder isOsEnvironTypeCheck;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecker);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::checkAssignment);
    }

    private void setupTypeChecker(SubscriptionContext ctx) {
        this.isOsEnvironTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("os._Environ");
    }

    private void checkAssignment(SubscriptionContext ctx) {
        AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
        if (!AwsLambdaReservedEnvironmentVariableCheck.isInAWSLambdaFunction(assignment, ctx)) {
            return;
        }
        ExpressionList lhs = assignment.lhsExpressions().get(0);
        for (Expression lhsExpression : lhs.expressions()) {
            this.checkIfOsEnvironVariableAssignedToReservedName(ctx, assignment, lhsExpression);
        }
    }

    private void checkIfOsEnvironVariableAssignedToReservedName(SubscriptionContext ctx, AssignmentStatement assignment, Expression lhsExpression) {
        if (!lhsExpression.is(Tree.Kind.SUBSCRIPTION)) {
            return;
        }
        SubscriptionExpression lhsSubscription = (SubscriptionExpression)lhsExpression;
        Expression object = lhsSubscription.object();
        if (!this.isOsEnvironTypeCheck.check(object.typeV2().unwrappedType()).equals((Object)TriBool.TRUE)) {
            return;
        }
        String subscriptValue = AwsLambdaReservedEnvironmentVariableCheck.getSubscriptString(lhsSubscription);
        if (subscriptValue != null && AWS_RESERVED_ENVIRONMENT_VARIABLES.contains(subscriptValue)) {
            ctx.addIssue(assignment, "Do not override reserved environment variable names in Lambda functions.");
        }
    }

    private static String getSubscriptString(SubscriptionExpression lhsSubscription) {
        Name subscriptName;
        Expression singleAssignedValueExpression;
        String subscriptValue = null;
        Expression subscriptExpression = lhsSubscription.subscripts().expressions().get(0);
        if (subscriptExpression.is(Tree.Kind.STRING_LITERAL)) {
            subscriptValue = ((StringLiteral)subscriptExpression).trimmedQuotesValue();
        } else if (subscriptExpression.is(Tree.Kind.NAME) && (singleAssignedValueExpression = Expressions.singleAssignedValue(subscriptName = (Name)subscriptExpression)) != null && singleAssignedValueExpression.is(Tree.Kind.STRING_LITERAL)) {
            subscriptValue = ((StringLiteral)singleAssignedValueExpression).trimmedQuotesValue();
        }
        return subscriptValue;
    }

    private static boolean isInAWSLambdaFunction(AssignmentStatement statement, SubscriptionContext ctx) {
        Tree parentFunctionDef = TreeUtils.firstAncestorOfKind(statement.parent(), Tree.Kind.FUNCDEF);
        if (parentFunctionDef == null) {
            return false;
        }
        return AwsLambdaChecksUtils.isLambdaHandler(ctx, (FunctionDef)parentFunctionDef);
    }
}

