/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7609")
public class AwsCustomMetricNamespaceCheck
extends PythonSubscriptionCheck {
    public static final String NAMESPACE_ARGUMENT_KEYWORD = "Namespace";
    private TypeCheckBuilder isBoto3ClientPutMetricDataCheck;
    private TypeCheckBuilder isAioBotocoreClientPutMetricDataCheck;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initializeCheck(SubscriptionContext ctx) {
        this.isBoto3ClientPutMetricDataCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("botocore.client.BaseClient.put_metric_data");
        this.isAioBotocoreClientPutMetricDataCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("aiobotocore.client.AioBaseClient.put_metric_data");
    }

    private void check(SubscriptionContext ctx) {
        RegularArgument argument;
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (this.isSensitiveCall(callExpression) && (argument = TreeUtils.argumentByKeyword(NAMESPACE_ARGUMENT_KEYWORD, callExpression.arguments())) != null && AwsCustomMetricNamespaceCheck.isInvalidArgumentValue(argument)) {
            ctx.addIssue(argument, "Do not use AWS reserved namespace that begins with 'AWS/' for custom metrics.");
        }
    }

    private boolean isSensitiveCall(CallExpression callExpression) {
        PythonType type = TreeUtils.inferSingleAssignedExpressionType(callExpression.callee());
        return this.isBoto3ClientPutMetricDataCheck.check(type).isTrue() || this.isAioBotocoreClientPutMetricDataCheck.check(type).isTrue();
    }

    private static boolean isInvalidArgumentValue(RegularArgument regularArgument) {
        return Optional.of(regularArgument).map(RegularArgument::expression).flatMap(Expressions::ifNameGetSingleAssignedNonNameValue).flatMap(TreeUtils.toOptionalInstanceOfMapper(StringLiteral.class)).map(StringLiteral::trimmedQuotesValue).filter(value -> value.startsWith("AWS/")).isPresent();
    }
}

