/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7515")
public class AsyncWithContextManagerCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use \"async with\" instead of \"with\" for this asynchronous context manager.";
    private static final String SECONDARY_TYPE_DEFINITION = "This context manager implements the async context manager protocol.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private TypeCheckBuilder hasAsyncEnter;
    private TypeCheckBuilder hasAsyncExit;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecker);
        context.registerSyntaxNodeConsumer(Tree.Kind.WITH_STMT, this::checkWithStatement);
    }

    private void setupTypeChecker(SubscriptionContext ctx) {
        this.hasAsyncEnter = ctx.typeChecker().typeCheckBuilder().hasMember("__aenter__");
        this.hasAsyncExit = ctx.typeChecker().typeCheckBuilder().hasMember("__aexit__");
    }

    private void checkWithStatement(SubscriptionContext ctx) {
        WithStatement withStatement = (WithStatement)ctx.syntaxNode();
        if (withStatement.isAsync()) {
            return;
        }
        Token asyncToken = TreeUtils.asyncTokenOfEnclosingFunction(withStatement).orElse(null);
        if (asyncToken == null) {
            return;
        }
        for (WithItem item : withStatement.withItems()) {
            Expression contextManager = item.test();
            PythonType contextManagerType = contextManager.typeV2();
            if (!this.implementsAsyncContextManagerProtocol(contextManagerType)) continue;
            PythonCheck.PreciseIssue issue = ctx.addIssue(withStatement.withKeyword(), MESSAGE).secondary(asyncToken, SECONDARY_MESSAGE);
            contextManagerType.definitionLocation().ifPresent(location -> issue.secondary((LocationInFile)location, SECONDARY_TYPE_DEFINITION));
            break;
        }
    }

    private boolean implementsAsyncContextManagerProtocol(PythonType type) {
        return this.hasAsyncEnter.check(type) == TriBool.TRUE && this.hasAsyncExit.check(type) == TriBool.TRUE;
    }
}

