/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.hotspots.CommonValidationUtils;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7486")
public class AsyncLongSleepCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace this call with \"%s.sleep_forever()\" as the sleep duration exceeds 24 hours.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final String QUICK_FIX_MESSAGE = "Replace with %s";
    private static final int SECONDS_IN_DAY = 86400;
    private TypeCheckBuilder isTrioSleepCall;
    private TypeCheckBuilder isAnyioSleepCall;
    private final Map<String, String> asyncLibraryAliases = new HashMap<String, String>();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, this::checkImportName);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkAsyncLongSleep);
    }

    private void setupCheck(SubscriptionContext ctx) {
        this.isTrioSleepCall = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("trio.sleep");
        this.isAnyioSleepCall = ctx.typeChecker().typeCheckBuilder().isTypeWithName("anyio.sleep");
        this.asyncLibraryAliases.clear();
    }

    private void checkImportName(SubscriptionContext ctx) {
        ImportName importName = (ImportName)ctx.syntaxNode();
        for (AliasedName module : importName.modules()) {
            String alias;
            List<Name> names = module.dottedName().names();
            if (names.size() > 1) continue;
            String moduleName = names.get(0).name();
            Name aliasName = module.alias();
            String string = alias = aliasName != null ? aliasName.name() : moduleName;
            if (!"trio".equals(moduleName) && !"anyio".equals(moduleName)) continue;
            this.asyncLibraryAliases.put(moduleName, alias);
        }
    }

    private void checkAsyncLongSleep(SubscriptionContext context) {
        String libraryName;
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Expression callee = callExpression.callee();
        if (this.isTrioSleepCall.check(callee.typeV2()) == TriBool.TRUE) {
            libraryName = "trio";
        } else if (this.isAnyioSleepCall.check(callee.typeV2()) == TriBool.TRUE) {
            libraryName = "anyio";
        } else {
            return;
        }
        Token asyncToken = TreeUtils.asyncTokenOfEnclosingFunction(callExpression).orElse(null);
        if (asyncToken == null) {
            return;
        }
        Expression durationExpr = AsyncLongSleepCheck.extractDurationExpression(callExpression, "trio".equals(libraryName) ? "seconds" : "delay").orElse(null);
        if (durationExpr == null) {
            return;
        }
        if (CommonValidationUtils.isMoreThan(durationExpr, 86400)) {
            String message = String.format(MESSAGE, libraryName);
            PythonCheck.PreciseIssue issue = context.addIssue(callExpression, message).secondary(asyncToken, SECONDARY_MESSAGE);
            this.createQuickFix(libraryName, callExpression).ifPresent(issue::addQuickFix);
        }
    }

    private static Optional<Expression> extractDurationExpression(CallExpression callExpression, String paramName) {
        return Optional.ofNullable(TreeUtils.nthArgumentOrKeyword(0, paramName, callExpression.arguments())).map(RegularArgument::expression);
    }

    private Optional<PythonQuickFix> createQuickFix(String libraryName, CallExpression callExpression) {
        String alias = this.asyncLibraryAliases.get(libraryName);
        if (alias == null) {
            return Optional.empty();
        }
        String replacement = alias + ".sleep_forever()";
        String quickFixMsg = String.format(QUICK_FIX_MESSAGE, replacement);
        return Optional.of(PythonQuickFix.newQuickFix(quickFixMsg).addTextEdit(TextEditUtils.replace(callExpression, replacement)).build());
    }
}

