/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.AwsLambdaChecksUtils;

@Rule(key="S7614")
public class AsyncAwsLambdaHandlerCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove the `async` keyword from this AWS Lambda handler definition.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, AsyncAwsLambdaHandlerCheck::checkAsyncLambdaHandler);
    }

    private static void checkAsyncLambdaHandler(SubscriptionContext ctx) {
        FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
        Token asyncToken = functionDef.asyncKeyword();
        if (asyncToken != null && AwsLambdaChecksUtils.isOnlyLambdaHandler(ctx, functionDef)) {
            ctx.addIssue(asyncToken, MESSAGE);
        }
    }
}

