/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S930")
public class ArgumentNumberCheck
extends PythonSubscriptionCheck {
    private static final String FUNCTION_DEFINITION = "Function definition.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Optional.of(callExpression).map(CallExpression::calleeSymbol).map(SymbolUtils::getFunctionSymbols).filter(SymbolUtils::isEqualParameterCountAndNames).map(Collection::stream).flatMap(Stream::findFirst).ifPresent(functionSymbol -> ArgumentNumberCheck.checkFunctionSymbol(ctx, callExpression, functionSymbol));
        });
    }

    private static void checkFunctionSymbol(SubscriptionContext ctx, CallExpression callExpression, FunctionSymbol functionSymbol) {
        if (ArgumentNumberCheck.isException(callExpression, functionSymbol)) {
            return;
        }
        ArgumentNumberCheck.checkPositionalParameters(ctx, callExpression, functionSymbol);
        ArgumentNumberCheck.checkKeywordArguments(ctx, callExpression, functionSymbol, callExpression.callee());
    }

    private static void checkPositionalParameters(SubscriptionContext ctx, CallExpression callExpression, FunctionSymbol functionSymbol) {
        int self = 0;
        if (functionSymbol.isInstanceMethod() && callExpression.callee().is(Tree.Kind.QUALIFIED_EXPR) && !ArgumentNumberCheck.isCalledAsClassMethod((QualifiedExpression)callExpression.callee())) {
            self = 1;
        }
        Map<String, FunctionSymbol.Parameter> positionalParamsWithoutDefault = ArgumentNumberCheck.positionalParamsWithoutDefault(functionSymbol);
        long nbPositionalParamsWithDefault = functionSymbol.parameters().stream().filter(parameterName -> !parameterName.isKeywordOnly() && parameterName.hasDefaultValue()).count();
        List<RegularArgument> arguments = callExpression.arguments().stream().map(RegularArgument.class::cast).toList();
        long nbPositionalArgs = arguments.stream().filter(a -> a.keywordArgument() == null).count();
        long nbNonKeywordOnlyPassedWithKeyword = arguments.stream().map(RegularArgument::keywordArgument).filter(k -> k != null && positionalParamsWithoutDefault.containsKey(k.name()) && !((FunctionSymbol.Parameter)positionalParamsWithoutDefault.get(k.name())).isPositionalOnly()).count();
        int minimumPositionalArgs = positionalParamsWithoutDefault.size();
        String expected = "" + (minimumPositionalArgs - self);
        long nbMissingArgs = (long)minimumPositionalArgs - nbPositionalArgs - (long)self - nbNonKeywordOnlyPassedWithKeyword;
        if (nbMissingArgs > 0L) {
            String message = "Add " + nbMissingArgs + " missing arguments; ";
            if (nbPositionalParamsWithDefault > 0L) {
                expected = "at least " + expected;
            }
            ArgumentNumberCheck.addPositionalIssue(ctx, callExpression.callee(), functionSymbol, message, expected);
        } else if (nbMissingArgs + nbPositionalParamsWithDefault + nbNonKeywordOnlyPassedWithKeyword < 0L) {
            String message = "Remove " + (-nbMissingArgs - nbPositionalParamsWithDefault) + " unexpected arguments; ";
            if (nbPositionalParamsWithDefault > 0L) {
                expected = "at most " + ((long)(minimumPositionalArgs - self) + nbPositionalParamsWithDefault);
            }
            ArgumentNumberCheck.addPositionalIssue(ctx, callExpression.callee(), functionSymbol, message, expected);
        }
    }

    private static boolean isCalledAsClassMethod(QualifiedExpression callee) {
        return TreeUtils.getSymbolFromTree(callee.qualifier()).filter(ArgumentNumberCheck::isParamOfClassMethod).isPresent();
    }

    private static boolean isParamOfClassMethod(Symbol symbol) {
        return symbol.usages().stream().anyMatch(usage -> usage.kind() == Usage.Kind.PARAMETER && ArgumentNumberCheck.isParamOfClassMethod(usage.tree()));
    }

    private static boolean isParamOfClassMethod(Tree tree) {
        FunctionDef functionDef = (FunctionDef)TreeUtils.firstAncestorOfKind(tree, Tree.Kind.FUNCDEF);
        return Optional.ofNullable(TreeUtils.getFunctionSymbolFromDef(functionDef)).filter(functionSymbol -> functionSymbol.decorators().stream().anyMatch("classmethod"::equals)).isPresent();
    }

    private static Map<String, FunctionSymbol.Parameter> positionalParamsWithoutDefault(FunctionSymbol functionSymbol) {
        int unnamedIndex = 0;
        HashMap<String, FunctionSymbol.Parameter> result = new HashMap<String, FunctionSymbol.Parameter>();
        for (FunctionSymbol.Parameter parameter : functionSymbol.parameters()) {
            if (parameter.isKeywordOnly() || parameter.hasDefaultValue()) continue;
            String name = parameter.name();
            if (name == null) {
                result.put("!unnamed" + unnamedIndex, parameter);
                ++unnamedIndex;
                continue;
            }
            result.put(parameter.name(), parameter);
        }
        return result;
    }

    private static void addPositionalIssue(SubscriptionContext ctx, Tree tree, FunctionSymbol functionSymbol, String message, String expected) {
        String msg = message + "'" + functionSymbol.name() + "' expects " + expected + " positional arguments.";
        PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(tree, msg);
        ArgumentNumberCheck.addSecondary(functionSymbol, preciseIssue);
    }

    private static boolean isReceiverClassSymbol(QualifiedExpression qualifiedExpression) {
        return TreeUtils.getSymbolFromTree(qualifiedExpression.qualifier()).filter(symbol -> symbol.kind() == Symbol.Kind.CLASS).isPresent();
    }

    private static boolean isException(CallExpression callExpression, FunctionSymbol functionSymbol) {
        return functionSymbol.hasDecorators() || functionSymbol.hasVariadicParameter() || callExpression.arguments().stream().anyMatch(argument -> argument.is(Tree.Kind.UNPACKING_EXPR)) || ArgumentNumberCheck.extendsZopeInterface(((FunctionSymbolImpl)functionSymbol).owner()) || callExpression.callee().is(Tree.Kind.QUALIFIED_EXPR) && ArgumentNumberCheck.isReceiverClassSymbol((QualifiedExpression)callExpression.callee());
    }

    private static boolean extendsZopeInterface(@Nullable Symbol symbol) {
        if (symbol != null && symbol.kind() == Symbol.Kind.CLASS) {
            return ((ClassSymbol)symbol).isOrExtends("zope.interface.Interface");
        }
        return false;
    }

    private static void addSecondary(FunctionSymbol functionSymbol, PythonCheck.PreciseIssue preciseIssue) {
        LocationInFile definitionLocation = functionSymbol.definitionLocation();
        if (definitionLocation != null) {
            preciseIssue.secondary(definitionLocation, FUNCTION_DEFINITION);
        }
    }

    private static void checkKeywordArguments(SubscriptionContext ctx, CallExpression callExpression, FunctionSymbol functionSymbol, Expression callee) {
        List<FunctionSymbol.Parameter> parameters = functionSymbol.parameters();
        Set mandatoryParamNamesKeywordOnly = parameters.stream().filter(parameterName -> parameterName.isKeywordOnly() && !parameterName.hasDefaultValue()).map(FunctionSymbol.Parameter::name).collect(Collectors.toSet());
        for (Argument argument : callExpression.arguments()) {
            RegularArgument arg = (RegularArgument)argument;
            Name keyword = arg.keywordArgument();
            if (keyword == null) continue;
            if (parameters.stream().noneMatch(parameter -> keyword.name().equals(parameter.name()) && !parameter.isPositionalOnly())) {
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(argument, "Remove this unexpected named argument '" + keyword.name() + "'.");
                ArgumentNumberCheck.addSecondary(functionSymbol, preciseIssue);
                continue;
            }
            mandatoryParamNamesKeywordOnly.remove(keyword.name());
        }
        if (!mandatoryParamNamesKeywordOnly.isEmpty()) {
            StringBuilder message = new StringBuilder("Add the missing keyword arguments: ");
            for (String param : mandatoryParamNamesKeywordOnly) {
                message.append("'").append(param).append("' ");
            }
            PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(callee, message.toString().trim());
            ArgumentNumberCheck.addSecondary(functionSymbol, preciseIssue);
        }
    }
}

