/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

public class ReachingDefinitionsAnalysis {
    private final Map<CfgBlock, ProgramStateAtBlock> programStateByBlock = new HashMap<CfgBlock, ProgramStateAtBlock>();
    private final Map<Name, Set<Expression>> assignedExpressionByName = new HashMap<Name, Set<Expression>>();
    private final PythonFile pythonFile;
    private final Map<Symbol, Set<Name>> assignedNamesBySymbol = new HashMap<Symbol, Set<Name>>();

    public ReachingDefinitionsAnalysis(PythonFile pythonFile) {
        this.pythonFile = pythonFile;
    }

    public Set<Expression> valuesAtLocation(Name variable) {
        Symbol symbol = variable.symbol();
        if (symbol == null) {
            return Collections.emptySet();
        }
        Set<Expression> assignedExpressions = this.assignedExpressionByName.get(variable);
        if (assignedExpressions != null) {
            return assignedExpressions;
        }
        FunctionDef enclosingFunction = (FunctionDef)TreeUtils.firstAncestorOfKind(variable, Tree.Kind.FUNCDEF);
        if (enclosingFunction == null || TreeUtils.hasDescendant(enclosingFunction, t -> t.is(Tree.Kind.TRY_STMT))) {
            return Collections.emptySet();
        }
        ControlFlowGraph cfg = ControlFlowGraph.build(enclosingFunction, this.pythonFile);
        if (cfg == null) {
            return Collections.emptySet();
        }
        this.compute(cfg, enclosingFunction.localVariables());
        return this.assignedExpressionByName.getOrDefault(variable, Collections.emptySet());
    }

    private Set<Expression> getAssignedExpressions(Name variable, ProgramStateAtElement programStateAtElement) {
        Symbol symbol = variable.symbol();
        if (symbol == null) {
            return Collections.emptySet();
        }
        boolean hasMissingBindingUsage = symbol.usages().stream().filter(Usage::isBindingUsage).anyMatch(u -> !this.assignedNamesBySymbol.getOrDefault(symbol, Collections.emptySet()).contains(u.tree()));
        if (hasMissingBindingUsage) {
            return Collections.emptySet();
        }
        return Optional.ofNullable(programStateAtElement.out.get(symbol)).orElse(Collections.emptySet());
    }

    private void compute(ControlFlowGraph cfg, Set<Symbol> localVariables) {
        HashMap initialState = new HashMap();
        for (Symbol variable : localVariables) {
            initialState.put(variable, new HashSet());
        }
        Set<CfgBlock> blocks = cfg.blocks();
        blocks.forEach(block -> this.programStateByBlock.put((CfgBlock)block, new ProgramStateAtBlock((CfgBlock)block, initialState)));
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>(blocks);
        while (!workList.isEmpty()) {
            CfgBlock currentBlock = (CfgBlock)workList.pop();
            ProgramStateAtBlock programStateAtBlock = this.programStateByBlock.get(currentBlock);
            boolean outHasChanged = programStateAtBlock.propagate();
            if (!outHasChanged) continue;
            currentBlock.successors().forEach(workList::push);
        }
        this.updateProgramStateByElement(cfg);
    }

    private void updateProgramStateByElement(ControlFlowGraph cfg) {
        for (CfgBlock block : cfg.blocks()) {
            Map<Symbol, Set<Expression>> inputState = this.programStateByBlock.get((Object)block).in;
            for (Tree element : block.elements()) {
                final ProgramStateAtElement programStateAtElement = new ProgramStateAtElement(inputState, element);
                element.accept(new BaseTreeVisitor(){

                    @Override
                    public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
                    }

                    @Override
                    public void visitName(Name name) {
                        ReachingDefinitionsAnalysis.this.assignedExpressionByName.put(name, ReachingDefinitionsAnalysis.this.getAssignedExpressions(name, programStateAtElement));
                    }
                });
                inputState = programStateAtElement.out;
            }
        }
    }

    private static Map<Symbol, Set<Expression>> join(Map<Symbol, Set<Expression>> programState1, Map<Symbol, Set<Expression>> programState2) {
        HashMap<Symbol, Set<Expression>> result = new HashMap<Symbol, Set<Expression>>();
        HashSet<Symbol> allKeys = new HashSet<Symbol>(programState1.keySet());
        allKeys.addAll(programState2.keySet());
        for (Symbol key : allKeys) {
            HashSet union = new HashSet();
            union.addAll(programState1.getOrDefault(key, Collections.emptySet()));
            union.addAll(programState2.getOrDefault(key, Collections.emptySet()));
            result.put(key, union);
        }
        return result;
    }

    private void updateProgramState(Tree element, Map<Symbol, Set<Expression>> out) {
        if (element.is(Tree.Kind.ASSIGNMENT_STMT)) {
            this.updateStateForAssignment((AssignmentStatement)element, out);
        }
        if (element.is(Tree.Kind.ANNOTATED_ASSIGNMENT)) {
            this.updateStateForAnnotatedAssignement((AnnotatedAssignment)element, out);
        }
    }

    private void updateStateForAssignment(AssignmentStatement element, Map<Symbol, Set<Expression>> programState) {
        List<Expression> lhsExpressions = element.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).toList();
        this.performUpdate(programState, lhsExpressions, element::assignedValue);
    }

    private void updateStateForAnnotatedAssignement(AnnotatedAssignment element, Map<Symbol, Set<Expression>> programState) {
        List<Expression> lhsExpressions = List.of(element.variable());
        this.performUpdate(programState, lhsExpressions, element::assignedValue);
    }

    private void performUpdate(Map<Symbol, Set<Expression>> programState, List<Expression> lhsExpressions, Supplier<Expression> assignedValueSupplier) {
        ReachingDefinitionsAnalysis.getLhsExpression(lhsExpressions).ifPresent(name -> TreeUtils.getSymbolFromTree(name).ifPresent(arg_0 -> this.lambda$performUpdate$4((Supplier)assignedValueSupplier, name, programState, arg_0)));
    }

    private void performUpdate(Symbol symbol, Supplier<Expression> assignedValueSupplier, Expression lhsExpression, Map<Symbol, Set<Expression>> programState) {
        this.assignedNamesBySymbol.computeIfAbsent(symbol, s -> new HashSet()).add((Name)lhsExpression);
        HashSet<Expression> assignedValues = new HashSet<Expression>();
        Expression assignedValue = assignedValueSupplier.get();
        if (assignedValue != null) {
            assignedValues.add(assignedValue);
            programState.put(symbol, assignedValues);
        }
    }

    private static Optional<Name> getLhsExpression(List<Expression> lhsExpressions) {
        return Stream.of(lhsExpressions).filter(l -> l.size() == 1).flatMap(Collection::stream).findFirst().flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class));
    }

    private /* synthetic */ void lambda$performUpdate$4(Supplier assignedValueSupplier, Name name, Map programState, Symbol symbol) {
        this.performUpdate(symbol, assignedValueSupplier, name, programState);
    }

    private class ProgramStateAtElement {
        private final Map<Symbol, Set<Expression>> out;

        public ProgramStateAtElement(Map<Symbol, Set<Expression>> in, Tree element) {
            this.out = ReachingDefinitionsAnalysis.join(in, Collections.emptyMap());
            ReachingDefinitionsAnalysis.this.updateProgramState(element, this.out);
        }
    }

    private class ProgramStateAtBlock {
        private final CfgBlock block;
        private Map<Symbol, Set<Expression>> in;
        private Map<Symbol, Set<Expression>> out = new HashMap<Symbol, Set<Expression>>();

        private ProgramStateAtBlock(CfgBlock block, Map<Symbol, Set<Expression>> initialState) {
            this.block = block;
            this.in = initialState;
            this.block.elements().forEach(element -> ReachingDefinitionsAnalysis.this.updateProgramState((Tree)element, this.out));
        }

        private boolean propagate() {
            this.block.predecessors().forEach(predecessor -> {
                this.in = ReachingDefinitionsAnalysis.join(this.in, ReachingDefinitionsAnalysis.this.programStateByBlock.get((Object)predecessor).out);
            });
            HashMap<Symbol, Set<Expression>> newOut = new HashMap<Symbol, Set<Expression>>(this.in);
            this.block.elements().forEach(element -> ReachingDefinitionsAnalysis.this.updateProgramState((Tree)element, (Map<Symbol, Set<Expression>>)newOut));
            boolean outHasChanged = !newOut.equals(this.out);
            this.out = newOut;
            return outHasChanged;
        }
    }
}

