/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.caching;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.plugins.python.api.caching.PythonReadCache;

public class PythonReadCacheImpl
implements PythonReadCache {
    private static final Logger LOG = LoggerFactory.getLogger(PythonReadCacheImpl.class);
    private final ReadCache readCache;

    public PythonReadCacheImpl(ReadCache readCache) {
        this.readCache = readCache;
    }

    @Override
    public InputStream read(String key) {
        return this.readCache.read(key);
    }

    @Override
    @CheckForNull
    public byte[] readBytes(String key) {
        if (this.readCache.contains(key)) {
            byte[] byArray;
            block10: {
                InputStream in = this.read(key);
                try {
                    byArray = in.readAllBytes();
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.debug("Unable to read data for key: \"{}\"", (Object)key);
                    }
                }
                in.close();
            }
            return byArray;
        } else {
            LOG.trace("Cache miss for key '{}'", (Object)key);
        }
        return null;
    }

    @Override
    public boolean contains(String key) {
        return this.readCache.contains(key);
    }
}

