/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.api.types.v2.matchers;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.python.api.types.v2.matchers.TypeMatcher;
import org.sonar.python.api.types.v2.matchers.TypeMatcherImpl;
import org.sonar.python.types.v2.matchers.AllTypePredicate;
import org.sonar.python.types.v2.matchers.AnyTypePredicate;
import org.sonar.python.types.v2.matchers.HasFQNPredicate;
import org.sonar.python.types.v2.matchers.HasMemberPredicate;
import org.sonar.python.types.v2.matchers.HasMemberSatisfyingPredicate;
import org.sonar.python.types.v2.matchers.IsObjectSatisfyingPredicate;
import org.sonar.python.types.v2.matchers.IsObjectSubtypeOfPredicate;
import org.sonar.python.types.v2.matchers.IsTypePredicate;
import org.sonar.python.types.v2.matchers.TypePredicate;
import org.sonar.python.types.v2.matchers.TypeSourcePredicate;

public final class TypeMatchers {
    private TypeMatchers() {
    }

    public static TypeMatcher all(Stream<TypeMatcher> matchers) {
        List<TypePredicate> predicates = matchers.map(TypeMatchers::getTypePredicate).toList();
        return new TypeMatcherImpl(new AllTypePredicate(predicates));
    }

    public static TypeMatcher all(List<TypeMatcher> matchers) {
        List<TypePredicate> predicates = matchers.stream().map(TypeMatchers::getTypePredicate).toList();
        return new TypeMatcherImpl(new AllTypePredicate(predicates));
    }

    public static TypeMatcher all(TypeMatcher ... matchers) {
        List<TypePredicate> predicates = Arrays.stream(matchers).map(TypeMatchers::getTypePredicate).toList();
        return new TypeMatcherImpl(new AllTypePredicate(predicates));
    }

    public static TypeMatcher any(Stream<TypeMatcher> matchers) {
        List<TypePredicate> predicates = matchers.map(TypeMatchers::getTypePredicate).toList();
        return new TypeMatcherImpl(new AnyTypePredicate(predicates));
    }

    public static TypeMatcher any(List<TypeMatcher> matchers) {
        List<TypePredicate> predicates = matchers.stream().map(TypeMatchers::getTypePredicate).toList();
        return new TypeMatcherImpl(new AnyTypePredicate(predicates));
    }

    public static TypeMatcher any(TypeMatcher ... matchers) {
        List<TypePredicate> predicates = Arrays.stream(matchers).map(TypeMatchers::getTypePredicate).toList();
        return new TypeMatcherImpl(new AnyTypePredicate(predicates));
    }

    public static TypeMatcher withFQN(String fqn) {
        return new TypeMatcherImpl(new HasFQNPredicate(fqn));
    }

    public static TypeMatcher isObjectSatisfying(TypeMatcher matcher) {
        TypePredicate predicate = TypeMatchers.getTypePredicate(matcher);
        return new TypeMatcherImpl(new IsObjectSatisfyingPredicate(predicate));
    }

    public static TypeMatcher isType(String fqn) {
        return new TypeMatcherImpl(new IsTypePredicate(fqn));
    }

    public static TypeMatcher isObjectOfType(String fqn) {
        return TypeMatchers.isObjectSatisfying(TypeMatchers.isType(fqn));
    }

    public static TypeMatcher isObjectOfSubType(String fqn) {
        return new TypeMatcherImpl(new IsObjectSubtypeOfPredicate(fqn));
    }

    public static TypeMatcher hasTypeSource(TypeSource typeSource) {
        return new TypeMatcherImpl(new TypeSourcePredicate(typeSource));
    }

    public static TypeMatcher hasMember(String memberName) {
        return new TypeMatcherImpl(new HasMemberPredicate(memberName));
    }

    public static TypeMatcher hasMemberSatisfying(String memberName, TypeMatcher matcher) {
        return new TypeMatcherImpl(new HasMemberSatisfyingPredicate(memberName, TypeMatchers.getTypePredicate(matcher)));
    }

    @VisibleForTesting
    static TypePredicate getTypePredicate(TypeMatcher matcher) {
        if (matcher instanceof TypeMatcherImpl) {
            TypeMatcherImpl typeMatcherImpl = (TypeMatcherImpl)matcher;
            return typeMatcherImpl.predicate();
        }
        throw new IllegalArgumentException("Unsupported type matcher: " + matcher.getClass().getName());
    }
}

