/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.api.types.v2.matchers;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.Set;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.python.api.types.v2.matchers.TypeMatcher;
import org.sonar.python.types.v2.matchers.TypePredicate;

@Beta
record TypeMatcherImpl(TypePredicate predicate) implements TypeMatcher
{
    @Override
    public TriBool evaluateFor(Expression expr, SubscriptionContext ctx) {
        PythonType candidate;
        PythonType type = expr.typeV2();
        Set<PythonType> candidates = TypeMatcherImpl.extractCandidates(type);
        TriBool result = TriBool.TRUE;
        Iterator<PythonType> iterator = candidates.iterator();
        while (iterator.hasNext() && !(result = result.conservativeAnd(this.predicate.check(candidate = iterator.next(), ctx))).isUnknown()) {
        }
        return result;
    }

    @Override
    public boolean isTrueFor(Expression expr, SubscriptionContext ctx) {
        return this.evaluateFor(expr, ctx).isTrue();
    }

    @VisibleForTesting
    static Set<PythonType> extractCandidates(PythonType type) {
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            return unionType.candidates();
        }
        return Set.of(type);
    }
}

