/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.api;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.sslr.grammar.LexerfulGrammarBuilder;

public class PythonGrammarBuilder {
    public static final String ASYNC = "async";

    public Grammar create() {
        LexerfulGrammarBuilder b = LexerfulGrammarBuilder.create();
        this.setupRules(b);
        b.setRootRule(PythonGrammar.FILE_INPUT);
        return b.buildWithMemoizationOfMatchesForAllRules();
    }

    protected void setupRules(LexerfulGrammarBuilder b) {
        this.fileInput(b);
        this.grammar(b);
        this.compoundStatements(b);
        this.simpleStatements(b);
        this.expressions(b);
    }

    protected void fileInput(LexerfulGrammarBuilder b) {
        b.rule(PythonGrammar.FILE_INPUT).is(b.zeroOrMore(b.firstOf(PythonTokenType.NEWLINE, PythonGrammar.STATEMENT)), GenericTokenType.EOF);
    }

    protected void grammar(LexerfulGrammarBuilder b) {
        b.rule(PythonGrammar.EXPRESSION_STMT).is(b.sequence(PythonGrammar.TESTLIST_STAR_EXPR, b.firstOf(PythonGrammar.ANNASSIGN, b.sequence(PythonGrammar.AUGASSIGN, b.firstOf(PythonGrammar.YIELD_EXPR, PythonGrammar.EXPRESSIONS)), b.zeroOrMore("=", PythonGrammar.ANNOTATED_RHS))));
        b.rule(PythonGrammar.ANNASSIGN).is(":", PythonGrammar.EXPRESSION, b.optional("=", PythonGrammar.ANNOTATED_RHS));
        b.rule(PythonGrammar.TESTLIST_STAR_EXPR).is(b.firstOf(PythonGrammar.EXPRESSION, PythonGrammar.STAR_EXPR), b.zeroOrMore(",", b.firstOf(PythonGrammar.EXPRESSION, PythonGrammar.STAR_EXPR)), b.optional(","));
        b.rule(PythonGrammar.AUGASSIGN).is(b.firstOf("+=", "-=", "*=", "/=", "//=", "%=", "**=", ">>=", "<<=", "&=", "^=", "|=", "@="));
        this.annotatedRhs(b);
        b.rule(PythonGrammar.NAMED_EXPR_TEST).is(PythonGrammar.EXPRESSION, b.optional(PythonPunctuator.WALRUS_OPERATOR, PythonGrammar.EXPRESSION));
        b.rule(PythonGrammar.STAR_NAMED_EXPRESSIONS).is(PythonGrammar.STAR_NAMED_EXPRESSION, b.zeroOrMore(",", PythonGrammar.STAR_NAMED_EXPRESSION), b.optional(","));
        b.rule(PythonGrammar.STAR_NAMED_EXPRESSION).is(b.firstOf(PythonGrammar.STAR_EXPR, PythonGrammar.NAMED_EXPR_TEST));
        b.rule(PythonGrammar.EXPRESSION).is(b.firstOf(b.sequence(PythonGrammar.OR_TEST, b.optional("if", PythonGrammar.OR_TEST, "else", PythonGrammar.EXPRESSION)), PythonGrammar.LAMBDEF));
        b.rule(PythonGrammar.TEST_NOCOND).is(b.firstOf(PythonGrammar.OR_TEST, PythonGrammar.LAMBDEF_NOCOND));
        b.rule(PythonGrammar.LAMBDEF).is("lambda", b.optional(PythonGrammar.VARARGSLIST), ":", PythonGrammar.EXPRESSION);
        b.rule(PythonGrammar.LAMBDEF_NOCOND).is("lambda", b.optional(PythonGrammar.VARARGSLIST), ":", PythonGrammar.TEST_NOCOND);
        b.rule(PythonGrammar.STAR_EXPR).is("*", PythonGrammar.EXPR);
        b.rule(PythonGrammar.EXPR).is(PythonGrammar.XOR_EXPR, b.zeroOrMore("|", PythonGrammar.XOR_EXPR));
        b.rule(PythonGrammar.FSTRING).is(PythonTokenType.FSTRING_START, b.zeroOrMore(b.firstOf(PythonGrammar.FSTRING_REPLACEMENT_FIELD, PythonTokenType.FSTRING_MIDDLE)), PythonTokenType.FSTRING_END);
        b.rule(PythonGrammar.FSTRING_REPLACEMENT_FIELD).is(PythonPunctuator.LCURLYBRACE, b.firstOf(PythonGrammar.YIELD_EXPR, PythonGrammar.TESTLIST_STAR_EXPR), b.optional(PythonPunctuator.ASSIGN), b.optional("!", b.firstOf("s", "r", "a")), b.optional(PythonGrammar.FORMAT_SPECIFIER), PythonPunctuator.RCURLYBRACE);
        b.rule(PythonGrammar.FORMAT_SPECIFIER).is(":", b.zeroOrMore(b.firstOf(PythonTokenType.FSTRING_MIDDLE, PythonGrammar.FSTRING_REPLACEMENT_FIELD)));
        b.rule(PythonGrammar.TSTRING).is(PythonTokenType.TSTRING_START, b.zeroOrMore(b.firstOf(PythonGrammar.FSTRING_REPLACEMENT_FIELD, PythonTokenType.FSTRING_MIDDLE)), PythonTokenType.FSTRING_END);
        b.rule(PythonGrammar.STRINGS).is(b.firstOf(b.oneOrMore(b.firstOf(PythonGrammar.FSTRING, PythonTokenType.STRING)), b.oneOrMore(PythonGrammar.TSTRING)));
        b.rule(PythonGrammar.FACTOR).is(b.firstOf(b.sequence(b.firstOf("+", "-", "~"), PythonGrammar.FACTOR), PythonGrammar.POWER)).skipIfOneChild();
        b.rule(PythonGrammar.POWER).is(b.firstOf(b.sequence(b.optional("await"), PythonGrammar.ATOM, b.zeroOrMore(PythonGrammar.TRAILER), b.optional("**", PythonGrammar.FACTOR)), "await")).skipIfOneChild();
        b.rule(PythonGrammar.ATOM).is(b.firstOf(b.sequence("(", b.optional(b.firstOf(PythonGrammar.YIELD_EXPR, PythonGrammar.TESTLIST_COMP)), ")"), b.sequence("[", b.optional(PythonGrammar.TESTLIST_COMP), "]"), b.sequence("{", b.optional(PythonGrammar.DICTORSETMAKER), "}"), b.sequence("`", PythonGrammar.EXPRESSION, b.zeroOrMore(",", PythonGrammar.EXPRESSION), "`"), PythonGrammar.NAME, PythonTokenType.NUMBER, PythonGrammar.STRINGS, PythonGrammar.ELLIPSIS, PythonKeyword.NONE));
        b.rule(PythonGrammar.ELLIPSIS).is(b.sequence(".", ".", "."));
        b.rule(PythonGrammar.TESTLIST_COMP).is(b.firstOf(PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.STAR_EXPR), b.firstOf(PythonGrammar.COMP_FOR, b.sequence(b.zeroOrMore(",", b.firstOf(PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.STAR_EXPR)), b.optional(","))));
        b.rule(PythonGrammar.TRAILER).is(b.firstOf(b.sequence("(", b.optional(PythonGrammar.ARGLIST), ")"), b.sequence("[", PythonGrammar.SUBSCRIPTLIST, "]"), b.sequence(".", PythonGrammar.NAME)));
        b.rule(PythonGrammar.SUBSCRIPTLIST).is(PythonGrammar.SUBSCRIPT, b.zeroOrMore(",", PythonGrammar.SUBSCRIPT), b.optional(","));
        b.rule(PythonGrammar.SUBSCRIPT).is(b.firstOf(b.sequence(b.optional(PythonGrammar.EXPRESSION), ":", b.optional(PythonGrammar.EXPRESSION), b.optional(PythonGrammar.SLICEOP)), b.firstOf(PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.STAR_EXPR)));
        b.rule(PythonGrammar.SLICEOP).is(":", b.optional(PythonGrammar.EXPRESSION));
        b.rule(PythonGrammar.EXPRLIST).is(b.firstOf(PythonGrammar.EXPR, PythonGrammar.STAR_EXPR), b.zeroOrMore(",", b.firstOf(PythonGrammar.EXPR, PythonGrammar.STAR_EXPR)), b.optional(","));
        b.rule(PythonGrammar.EXPRESSIONS).is(PythonGrammar.EXPRESSION, b.zeroOrMore(",", PythonGrammar.EXPRESSION), b.optional(","));
        b.rule(PythonGrammar.DICTORSETMAKER).is(b.firstOf(b.sequence(b.firstOf(b.sequence(PythonGrammar.EXPRESSION, ":", PythonGrammar.EXPRESSION), b.sequence("**", PythonGrammar.EXPR)), b.firstOf(PythonGrammar.COMP_FOR, b.sequence(b.zeroOrMore(",", b.firstOf(b.sequence(PythonGrammar.EXPRESSION, ":", PythonGrammar.EXPRESSION), b.sequence("**", PythonGrammar.EXPR))), b.optional(",")))), b.sequence(PythonGrammar.STAR_NAMED_EXPRESSION, b.firstOf(PythonGrammar.COMP_FOR, b.sequence(b.zeroOrMore(",", PythonGrammar.STAR_NAMED_EXPRESSION), b.optional(","))))));
        b.rule(PythonGrammar.ARGLIST).is(PythonGrammar.ARGUMENT, b.zeroOrMore(",", PythonGrammar.ARGUMENT), b.optional(","));
        b.rule(PythonGrammar.ARGUMENT).is(b.firstOf(b.sequence("*", PythonGrammar.EXPRESSION), b.sequence("**", PythonGrammar.EXPRESSION), b.sequence(PythonGrammar.EXPRESSION, PythonPunctuator.WALRUS_OPERATOR, PythonGrammar.EXPRESSION), b.sequence(PythonGrammar.EXPRESSION, "=", PythonGrammar.EXPRESSION), b.sequence(PythonGrammar.EXPRESSION, b.optional(PythonGrammar.COMP_FOR))));
        b.rule(PythonGrammar.COMP_ITER).is(b.firstOf(PythonGrammar.COMP_FOR, PythonGrammar.COMP_IF));
        b.rule(PythonGrammar.COMP_FOR).is(b.optional(ASYNC), "for", PythonGrammar.EXPRLIST, "in", PythonGrammar.EXPRESSIONS, b.optional(PythonGrammar.COMP_ITER));
        b.rule(PythonGrammar.COMP_IF).is("if", PythonGrammar.TEST_NOCOND, b.optional(PythonGrammar.COMP_ITER));
        b.rule(PythonGrammar.YIELD_EXPR).is(b.firstOf(b.sequence("yield", "from", PythonGrammar.EXPRESSION), b.sequence("yield", b.optional(PythonGrammar.TESTLIST_STAR_EXPR))));
        b.rule(PythonGrammar.NAME).is(GenericTokenType.IDENTIFIER);
        b.rule(PythonGrammar.VARARGSLIST).is(b.firstOf(b.sequence("**", PythonGrammar.NAME), b.sequence("*", b.optional(PythonGrammar.NAME), b.zeroOrMore(",", PythonGrammar.FPDEF, b.optional("=", PythonGrammar.EXPRESSION)), b.optional(",", "**", PythonGrammar.NAME)), b.sequence(PythonGrammar.FPDEF, b.optional("=", PythonGrammar.EXPRESSION), b.zeroOrMore(",", PythonGrammar.FPDEF, b.optional("=", PythonGrammar.EXPRESSION)), b.optional(",", "/", b.zeroOrMore(",", PythonGrammar.FPDEF, b.optional("=", PythonGrammar.EXPRESSION))), b.optional(",", b.firstOf(b.sequence("**", PythonGrammar.NAME), b.sequence("*", b.optional(PythonGrammar.NAME), b.zeroOrMore(",", PythonGrammar.FPDEF, b.optional("=", PythonGrammar.EXPRESSION)), b.optional(",", "**", PythonGrammar.NAME)))))), b.optional(","));
        b.rule(PythonGrammar.FPDEF).is(b.firstOf(PythonGrammar.NAME, b.sequence("(", PythonGrammar.FPLIST, ")")));
        b.rule(PythonGrammar.FPLIST).is(PythonGrammar.FPDEF, b.zeroOrMore(",", PythonGrammar.FPDEF), b.optional(","));
        b.rule(PythonGrammar.TYPEDARGSLIST).is(b.firstOf(b.sequence("**", PythonGrammar.TFPDEF, b.optional(",")), b.sequence("*", b.optional(PythonGrammar.TFPDEF), b.zeroOrMore(",", PythonGrammar.TFPDEF, b.optional("=", PythonGrammar.EXPRESSION)), b.optional(",", "**", PythonGrammar.TFPDEF), b.optional(",")), b.sequence(PythonGrammar.TFPDEF, b.optional("=", PythonGrammar.EXPRESSION), b.zeroOrMore(",", PythonGrammar.TFPDEF, b.optional("=", PythonGrammar.EXPRESSION)), b.optional(",", "/", b.zeroOrMore(",", PythonGrammar.TFPDEF, b.optional("=", PythonGrammar.EXPRESSION))), b.optional(",", b.optional(b.firstOf(b.sequence("**", PythonGrammar.TFPDEF), b.sequence("*", b.optional(PythonGrammar.TFPDEF), b.zeroOrMore(",", PythonGrammar.TFPDEF, b.optional("=", PythonGrammar.EXPRESSION)), b.optional(",", "**", PythonGrammar.TFPDEF))), b.optional(","))))));
        b.rule(PythonGrammar.TFPDEF).is(b.firstOf(b.sequence(PythonGrammar.NAME, b.optional(PythonGrammar.TYPE_ANNOTATION)), b.sequence("(", PythonGrammar.TFPLIST, ")")));
        b.rule(PythonGrammar.TYPE_ANNOTATION).is(":", b.optional("*"), PythonGrammar.EXPRESSION);
        b.rule(PythonGrammar.TFPLIST).is(PythonGrammar.TFPDEF, b.zeroOrMore(",", PythonGrammar.TFPDEF), b.optional(","));
    }

    protected void annotatedRhs(LexerfulGrammarBuilder b) {
        b.rule(PythonGrammar.ANNOTATED_RHS).is(b.firstOf(PythonGrammar.YIELD_EXPR, PythonGrammar.TESTLIST_STAR_EXPR));
    }

    protected void expressions(LexerfulGrammarBuilder b) {
        b.rule(PythonGrammar.M_EXPR).is(PythonGrammar.FACTOR, b.zeroOrMore(b.firstOf("*", "//", "/", "%", "@"), PythonGrammar.FACTOR)).skipIfOneChild();
        b.rule(PythonGrammar.A_EXPR).is(PythonGrammar.M_EXPR, b.zeroOrMore(b.firstOf("+", "-"), PythonGrammar.M_EXPR)).skipIfOneChild();
        b.rule(PythonGrammar.SHIFT_EXPR).is(PythonGrammar.A_EXPR, b.zeroOrMore(b.firstOf("<<", ">>"), PythonGrammar.A_EXPR)).skipIfOneChild();
        b.rule(PythonGrammar.AND_EXPR).is(PythonGrammar.SHIFT_EXPR, b.zeroOrMore("&", PythonGrammar.SHIFT_EXPR)).skipIfOneChild();
        b.rule(PythonGrammar.XOR_EXPR).is(PythonGrammar.AND_EXPR, b.zeroOrMore("^", PythonGrammar.AND_EXPR)).skipIfOneChild();
        b.rule(PythonGrammar.OR_EXPR).is(PythonGrammar.XOR_EXPR, b.zeroOrMore("|", PythonGrammar.XOR_EXPR)).skipIfOneChild();
        b.rule(PythonGrammar.COMPARISON).is(PythonGrammar.OR_EXPR, b.zeroOrMore(PythonGrammar.COMP_OPERATOR, PythonGrammar.OR_EXPR)).skipIfOneChild();
        b.rule(PythonGrammar.COMP_OPERATOR).is(b.firstOf("<", ">", "==", ">=", "<=", "!=", "<>", b.sequence("is", b.optional("not")), b.sequence(b.optional("not"), "in")));
        b.rule(PythonGrammar.OR_TEST).is(PythonGrammar.AND_TEST, b.zeroOrMore("or", PythonGrammar.AND_TEST)).skipIfOneChild();
        b.rule(PythonGrammar.AND_TEST).is(PythonGrammar.NOT_TEST, b.zeroOrMore("and", PythonGrammar.NOT_TEST)).skipIfOneChild();
        b.rule(PythonGrammar.NOT_TEST).is(b.firstOf(PythonGrammar.COMPARISON, b.sequence("not", PythonGrammar.NOT_TEST))).skipIfOneChild();
    }

    protected void simpleStatements(LexerfulGrammarBuilder b) {
        this.simpleStatement(b);
        b.rule(PythonGrammar.TYPE_ALIAS_STMT).is("type", PythonGrammar.NAME, b.optional(PythonGrammar.TYPE_PARAMS), "=", PythonGrammar.EXPRESSION);
        b.rule(PythonGrammar.PRINT_STMT).is("print", b.nextNot("="), b.nextNot("("), b.firstOf(b.sequence(">>", PythonGrammar.EXPRESSION, b.optional(b.oneOrMore(",", PythonGrammar.EXPRESSION), b.optional(","))), b.optional(PythonGrammar.EXPRESSION, b.zeroOrMore(",", PythonGrammar.EXPRESSION), b.optional(","))));
        b.rule(PythonGrammar.EXEC_STMT).is("exec", b.nextNot("("), PythonGrammar.EXPR, b.optional("in", PythonGrammar.EXPRESSION, b.optional(",", PythonGrammar.EXPRESSION)));
        b.rule(PythonGrammar.ASSERT_STMT).is("assert", PythonGrammar.EXPRESSION, b.optional(",", PythonGrammar.EXPRESSION));
        b.rule(PythonGrammar.PASS_STMT).is("pass");
        b.rule(PythonGrammar.DEL_STMT).is("del", PythonGrammar.EXPRLIST);
        b.rule(PythonGrammar.RETURN_STMT).is("return", b.optional(PythonGrammar.TESTLIST_STAR_EXPR));
        b.rule(PythonGrammar.YIELD_STMT).is(PythonGrammar.YIELD_EXPR);
        b.rule(PythonGrammar.RAISE_STMT).is("raise", b.optional(PythonGrammar.EXPRESSION, b.optional(b.firstOf(b.sequence("from", PythonGrammar.EXPRESSION), b.sequence(",", PythonGrammar.EXPRESSION, b.optional(",", PythonGrammar.EXPRESSION))))));
        b.rule(PythonGrammar.BREAK_STMT).is("break");
        b.rule(PythonGrammar.CONTINUE_STMT).is("continue");
        b.rule(PythonGrammar.IMPORT_STMT).is(b.firstOf(PythonGrammar.IMPORT_NAME, PythonGrammar.IMPORT_FROM));
        b.rule(PythonGrammar.IMPORT_NAME).is("import", PythonGrammar.DOTTED_AS_NAMES);
        b.rule(PythonGrammar.IMPORT_FROM).is("from", b.firstOf(b.sequence(b.zeroOrMore("."), PythonGrammar.DOTTED_NAME), b.oneOrMore(".")), "import", b.firstOf("*", b.sequence("(", PythonGrammar.IMPORT_AS_NAMES, ")"), PythonGrammar.IMPORT_AS_NAMES));
        b.rule(PythonGrammar.IMPORT_AS_NAME).is(PythonGrammar.NAME, b.optional("as", PythonGrammar.NAME));
        b.rule(PythonGrammar.DOTTED_AS_NAME).is(PythonGrammar.DOTTED_NAME, b.optional("as", PythonGrammar.NAME));
        b.rule(PythonGrammar.IMPORT_AS_NAMES).is(PythonGrammar.IMPORT_AS_NAME, b.zeroOrMore(",", PythonGrammar.IMPORT_AS_NAME), b.optional(","));
        b.rule(PythonGrammar.DOTTED_AS_NAMES).is(PythonGrammar.DOTTED_AS_NAME, b.zeroOrMore(",", PythonGrammar.DOTTED_AS_NAME));
        b.rule(PythonGrammar.GLOBAL_STMT).is("global", PythonGrammar.NAME, b.zeroOrMore(",", PythonGrammar.NAME));
        b.rule(PythonGrammar.NONLOCAL_STMT).is("nonlocal", PythonGrammar.NAME, b.zeroOrMore(",", PythonGrammar.NAME));
    }

    protected void simpleStatement(LexerfulGrammarBuilder b) {
        b.rule(PythonGrammar.SIMPLE_STMT).is(b.firstOf(PythonGrammar.TYPE_ALIAS_STMT, PythonGrammar.PRINT_STMT, PythonGrammar.EXEC_STMT, PythonGrammar.EXPRESSION_STMT, PythonGrammar.ASSERT_STMT, PythonGrammar.PASS_STMT, PythonGrammar.DEL_STMT, PythonGrammar.RETURN_STMT, PythonGrammar.YIELD_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.BREAK_STMT, PythonGrammar.CONTINUE_STMT, PythonGrammar.IMPORT_STMT, PythonGrammar.GLOBAL_STMT, PythonGrammar.NONLOCAL_STMT));
    }

    protected void compoundStatements(LexerfulGrammarBuilder b) {
        b.rule(PythonGrammar.COMPOUND_STMT).is(b.firstOf(PythonGrammar.IF_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.TRY_STMT, PythonGrammar.WITH_STMT, PythonGrammar.MATCH_STMT, PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF, PythonGrammar.ASYNC_STMT));
        b.rule(PythonGrammar.SUITE).is(b.firstOf(b.sequence(PythonGrammar.STMT_LIST, b.firstOf(PythonTokenType.NEWLINE, b.next(GenericTokenType.EOF), b.next(PythonTokenType.DEDENT))), b.sequence(PythonTokenType.NEWLINE, PythonTokenType.INDENT, b.oneOrMore(PythonGrammar.STATEMENT), PythonTokenType.DEDENT)));
        b.rule(PythonGrammar.STATEMENT).is(b.firstOf(b.sequence(PythonGrammar.STMT_LIST, b.firstOf(PythonTokenType.NEWLINE, b.next(GenericTokenType.EOF), b.next(PythonTokenType.DEDENT))), PythonGrammar.COMPOUND_STMT));
        b.rule(PythonGrammar.STMT_LIST).is(PythonGrammar.SIMPLE_STMT, b.zeroOrMore(";", PythonGrammar.SIMPLE_STMT), b.optional(";"));
        b.rule(PythonGrammar.IF_STMT).is("if", PythonGrammar.NAMED_EXPR_TEST, ":", PythonGrammar.SUITE, b.zeroOrMore("elif", PythonGrammar.NAMED_EXPR_TEST, ":", PythonGrammar.SUITE), b.optional("else", ":", PythonGrammar.SUITE));
        b.rule(PythonGrammar.WHILE_STMT).is("while", PythonGrammar.NAMED_EXPR_TEST, ":", PythonGrammar.SUITE, b.optional("else", ":", PythonGrammar.SUITE));
        b.rule(PythonGrammar.FOR_STMT).is("for", PythonGrammar.EXPRLIST, "in", PythonGrammar.STAR_NAMED_EXPRESSIONS, ":", PythonGrammar.SUITE, b.optional("else", ":", PythonGrammar.SUITE));
        b.rule(PythonGrammar.TRY_STMT).is("try", ":", PythonGrammar.SUITE, b.firstOf(b.sequence(b.oneOrMore(PythonGrammar.EXCEPT_CLAUSE, ":", PythonGrammar.SUITE), b.optional("else", ":", PythonGrammar.SUITE), b.optional("finally", ":", PythonGrammar.SUITE)), b.sequence("finally", ":", PythonGrammar.SUITE)));
        b.rule(PythonGrammar.EXCEPT_CLAUSE).is("except", b.optional("*"), b.optional(b.firstOf(b.sequence(PythonGrammar.EXPRESSION, "as", PythonGrammar.EXPRESSION), PythonGrammar.EXPRESSIONS)));
        b.rule(PythonGrammar.WITH_STMT).is(b.firstOf(b.sequence("with", "(", PythonGrammar.WITH_ITEM, b.zeroOrMore(",", PythonGrammar.WITH_ITEM), b.optional(","), ")", ":", PythonGrammar.SUITE), b.sequence("with", PythonGrammar.WITH_ITEM, b.zeroOrMore(",", PythonGrammar.WITH_ITEM), ":", PythonGrammar.SUITE)));
        b.rule(PythonGrammar.WITH_ITEM).is(PythonGrammar.EXPRESSION, b.optional("as", PythonGrammar.EXPR));
        b.rule(PythonGrammar.MATCH_STMT).is("match", PythonGrammar.SUBJECT_EXPR, ":", PythonTokenType.NEWLINE, PythonTokenType.INDENT, b.oneOrMore(PythonGrammar.CASE_BLOCK), PythonTokenType.DEDENT);
        b.rule(PythonGrammar.SUBJECT_EXPR).is(PythonGrammar.STAR_NAMED_EXPRESSIONS);
        b.rule(PythonGrammar.CASE_BLOCK).is("case", PythonGrammar.PATTERNS, b.optional(PythonGrammar.GUARD), ":", PythonGrammar.SUITE);
        b.rule(PythonGrammar.GUARD).is("if", PythonGrammar.NAMED_EXPR_TEST);
        b.rule(PythonGrammar.PATTERNS).is(b.firstOf(PythonGrammar.OPEN_SEQUENCE_PATTERN, PythonGrammar.PATTERN));
        b.rule(PythonGrammar.PATTERN).is(b.firstOf(PythonGrammar.AS_PATTERN, PythonGrammar.OR_PATTERN));
        b.rule(PythonGrammar.CLOSED_PATTERN).is(b.firstOf(PythonGrammar.CLASS_PATTERN, PythonGrammar.LITERAL_PATTERN, PythonGrammar.GROUP_PATTERN, PythonGrammar.WILDCARD_PATTERN, PythonGrammar.VALUE_PATTERN, PythonGrammar.CAPTURE_PATTERN, PythonGrammar.SEQUENCE_PATTERN, PythonGrammar.MAPPING_PATTERN));
        b.rule(PythonGrammar.AS_PATTERN).is(PythonGrammar.OR_PATTERN, "as", PythonGrammar.CAPTURE_PATTERN);
        b.rule(PythonGrammar.OR_PATTERN).is(PythonGrammar.CLOSED_PATTERN, b.zeroOrMore("|", PythonGrammar.CLOSED_PATTERN));
        b.rule(PythonGrammar.CAPTURE_PATTERN).is(PythonGrammar.NAME);
        b.rule(PythonGrammar.VALUE_PATTERN).is(PythonGrammar.ATTR);
        b.rule(PythonGrammar.MAPPING_PATTERN).is(b.firstOf(b.sequence("{", "}"), b.sequence("{", PythonGrammar.DOUBLE_STAR_PATTERN, b.optional(","), "}"), b.sequence("{", PythonGrammar.ITEMS_PATTERN, ",", PythonGrammar.DOUBLE_STAR_PATTERN, b.optional(","), "}"), b.sequence("{", PythonGrammar.ITEMS_PATTERN, b.optional(","), "}")));
        b.rule(PythonGrammar.ITEMS_PATTERN).is(PythonGrammar.KEY_VALUE_PATTERN, b.zeroOrMore(",", PythonGrammar.KEY_VALUE_PATTERN));
        b.rule(PythonGrammar.KEY_VALUE_PATTERN).is(b.firstOf(PythonGrammar.LITERAL_PATTERN, PythonGrammar.VALUE_PATTERN), ":", PythonGrammar.PATTERN);
        b.rule(PythonGrammar.DOUBLE_STAR_PATTERN).is("**", PythonGrammar.CAPTURE_PATTERN);
        b.rule(PythonGrammar.SEQUENCE_PATTERN).is(b.firstOf(b.sequence("[", b.optional(PythonGrammar.MAYBE_SEQUENCE_PATTERN), "]"), b.sequence("(", b.optional(PythonGrammar.OPEN_SEQUENCE_PATTERN), ")")));
        b.rule(PythonGrammar.OPEN_SEQUENCE_PATTERN).is(PythonGrammar.MAYBE_STAR_PATTERN, ",", b.optional(PythonGrammar.MAYBE_SEQUENCE_PATTERN));
        b.rule(PythonGrammar.MAYBE_SEQUENCE_PATTERN).is(PythonGrammar.MAYBE_STAR_PATTERN, b.zeroOrMore(",", PythonGrammar.MAYBE_STAR_PATTERN), b.optional(","));
        b.rule(PythonGrammar.MAYBE_STAR_PATTERN).is(b.firstOf(PythonGrammar.STAR_PATTERN, PythonGrammar.PATTERN));
        b.rule(PythonGrammar.STAR_PATTERN).is("*", b.firstOf(PythonGrammar.WILDCARD_PATTERN, PythonGrammar.CAPTURE_PATTERN));
        b.rule(PythonGrammar.CLASS_PATTERN).is(PythonGrammar.NAME_OR_ATTR, "(", b.optional(PythonGrammar.PATTERN_ARGS), ")");
        b.rule(PythonGrammar.NAME_OR_ATTR).is(PythonGrammar.NAME, b.zeroOrMore(".", PythonGrammar.NAME));
        b.rule(PythonGrammar.ATTR).is(PythonGrammar.NAME, b.oneOrMore(".", PythonGrammar.NAME));
        b.rule(PythonGrammar.PATTERN_ARGS).is(PythonGrammar.PATTERN_ARG, b.zeroOrMore(b.sequence(",", PythonGrammar.PATTERN_ARG)), b.optional(","));
        b.rule(PythonGrammar.PATTERN_ARG).is(b.firstOf(PythonGrammar.KEYWORD_PATTERN, PythonGrammar.PATTERN));
        b.rule(PythonGrammar.KEYWORD_PATTERN).is(PythonGrammar.NAME, "=", PythonGrammar.PATTERN);
        b.rule(PythonGrammar.LITERAL_PATTERN).is(b.firstOf(PythonGrammar.COMPLEX_NUMBER, PythonGrammar.SIGNED_NUMBER, PythonGrammar.STRINGS, PythonKeyword.NONE, "True", "False"));
        b.rule(PythonGrammar.COMPLEX_NUMBER).is(b.firstOf(b.sequence(PythonGrammar.SIGNED_NUMBER, "+", PythonTokenType.NUMBER), b.sequence(PythonGrammar.SIGNED_NUMBER, "-", PythonTokenType.NUMBER)));
        b.rule(PythonGrammar.SIGNED_NUMBER).is(b.firstOf(PythonTokenType.NUMBER, b.sequence("-", PythonTokenType.NUMBER)));
        b.rule(PythonGrammar.WILDCARD_PATTERN).is("_");
        b.rule(PythonGrammar.GROUP_PATTERN).is("(", PythonGrammar.PATTERN, ")");
        b.rule(PythonGrammar.FUNCDEF).is(b.optional(PythonGrammar.DECORATORS), b.optional(ASYNC), "def", PythonGrammar.FUNCNAME, b.optional(PythonGrammar.TYPE_PARAMS), "(", b.optional(PythonGrammar.TYPEDARGSLIST), ")", b.optional(PythonGrammar.FUN_RETURN_ANNOTATION), ":", PythonGrammar.SUITE);
        b.rule(PythonGrammar.FUNCNAME).is(PythonGrammar.NAME);
        b.rule(PythonGrammar.TYPE_PARAMS).is("[", PythonGrammar.TYPE_PARAM_SEQ, "]");
        b.rule(PythonGrammar.TYPE_PARAM_SEQ).is(PythonGrammar.TYPE_PARAM, b.zeroOrMore(",", PythonGrammar.TYPE_PARAM), b.optional(","));
        b.rule(PythonGrammar.TYPE_PARAM).is(b.firstOf(b.sequence(PythonGrammar.NAME, b.optional(PythonGrammar.TYPE_PARAM_BOUND), b.optional(PythonGrammar.TYPE_PARAM_DEFAULT)), b.sequence("*", PythonGrammar.NAME, b.optional(PythonGrammar.TYPE_PARAM_STARRED_DEFAULT)), b.sequence("**", PythonGrammar.NAME, b.optional(PythonGrammar.TYPE_PARAM_DEFAULT))));
        b.rule(PythonGrammar.TYPE_PARAM_BOUND).is(":", PythonGrammar.EXPRESSION);
        b.rule(PythonGrammar.TYPE_PARAM_DEFAULT).is("=", PythonGrammar.EXPRESSION);
        b.rule(PythonGrammar.TYPE_PARAM_STARRED_DEFAULT).is("=", b.firstOf(PythonGrammar.EXPRESSION, PythonGrammar.STAR_EXPR));
        b.rule(PythonGrammar.FUN_RETURN_ANNOTATION).is("-", ">", PythonGrammar.EXPRESSION);
        b.rule(PythonGrammar.DECORATORS).is(b.oneOrMore(PythonGrammar.DECORATOR));
        b.rule(PythonGrammar.DECORATOR).is("@", PythonGrammar.NAMED_EXPR_TEST, PythonTokenType.NEWLINE);
        b.rule(PythonGrammar.DOTTED_NAME).is(PythonGrammar.NAME, b.zeroOrMore(".", PythonGrammar.NAME));
        b.rule(PythonGrammar.CLASSDEF).is(b.optional(PythonGrammar.DECORATORS), "class", PythonGrammar.CLASSNAME, b.optional(PythonGrammar.TYPE_PARAMS), b.optional("(", b.optional(PythonGrammar.ARGLIST), ")"), ":", PythonGrammar.SUITE);
        b.rule(PythonGrammar.CLASSNAME).is(PythonGrammar.NAME);
        b.rule(PythonGrammar.ASYNC_STMT).is(ASYNC, b.firstOf(PythonGrammar.WITH_STMT, PythonGrammar.FOR_STMT));
    }
}

