/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.project.configuration.ProjectConfiguration;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.python.IPythonLocation;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.project.config.ProjectConfigurationBuilder;
import org.sonar.python.project.config.SignatureBasedAwsLambdaHandlersCollector;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.SymbolTable;
import org.sonar.python.semantic.v2.SymbolTableBuilderV2;
import org.sonar.python.semantic.v2.TypeInferenceV2;
import org.sonar.python.semantic.v2.typetable.ProjectLevelTypeTable;
import org.sonar.python.tree.IPythonTreeMaker;
import org.sonar.python.tree.PythonTreeMaker;

public class TestPythonVisitorRunner {
    private TestPythonVisitorRunner() {
    }

    public static PythonVisitorContext scanFile(File file, PythonCheck ... visitors) {
        PythonVisitorContext context = TestPythonVisitorRunner.createContext(file);
        for (PythonCheck visitor : visitors) {
            visitor.scanFile(context);
        }
        return context;
    }

    public static PythonVisitorContext scanNotebookFile(File file, Map<Integer, IPythonLocation> locations, String content, PythonCheck ... visitors) {
        PythonVisitorContext context = TestPythonVisitorRunner.createNotebookContext(file, locations, content, "", ProjectLevelSymbolTable.empty(), CacheContextImpl.dummyCache());
        for (PythonCheck visitor : visitors) {
            visitor.scanFile(context);
        }
        return context;
    }

    public static PythonVisitorContext createContext(File file) {
        return TestPythonVisitorRunner.createContext(file, null, null);
    }

    public static PythonVisitorContext createContext(File file, @Nullable File workingDirectory) {
        return TestPythonVisitorRunner.createContext(file, workingDirectory, null);
    }

    public static PythonVisitorContext createContext(File file, @Nullable File workingDirectory, @Nullable ProjectConfiguration projectConfiguration) {
        return TestPythonVisitorRunner.createContext(file, workingDirectory, "", ProjectLevelSymbolTable.empty(), CacheContextImpl.dummyCache(), projectConfiguration);
    }

    public static PythonVisitorContext createContext(File file, @Nullable File workingDirectory, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable, CacheContext cacheContext) {
        return TestPythonVisitorRunner.createContext(file, workingDirectory, packageName, projectLevelSymbolTable, cacheContext, null);
    }

    public static PythonVisitorContext createContext(File file, @Nullable File workingDirectory, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable, CacheContext cacheContext, @Nullable ProjectConfiguration projectConfiguration) {
        TestPythonFile pythonFile = new TestPythonFile(file);
        FileInput rootTree = TestPythonVisitorRunner.parseFile(pythonFile);
        ProjectLevelTypeTable typeTable = new ProjectLevelTypeTable(projectLevelSymbolTable);
        SymbolTableBuilderV2 symbolTableBuilderV2 = new SymbolTableBuilderV2(rootTree);
        SymbolTable symbolTableV2 = symbolTableBuilderV2.build();
        ModuleType moduleType = new TypeInferenceV2(typeTable, pythonFile, symbolTableV2, packageName).inferModuleType(rootTree);
        if (projectConfiguration == null) {
            ProjectConfigurationBuilder projectConfigurationBuilder = new ProjectConfigurationBuilder();
            new SignatureBasedAwsLambdaHandlersCollector().collect(projectConfigurationBuilder, rootTree, packageName);
            projectConfiguration = projectConfigurationBuilder.build();
        }
        return new PythonVisitorContext.Builder(rootTree, pythonFile).workingDirectory(workingDirectory).packageName(packageName).projectLevelSymbolTable(projectLevelSymbolTable).cacheContext(cacheContext).projectConfiguration(projectConfiguration).typeTable(typeTable).moduleType(moduleType).build();
    }

    public static PythonVisitorContext createContext(MockPythonFile file, @Nullable File workingDirectory, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable, CacheContext cacheContext) {
        FileInput rootTree = TestPythonVisitorRunner.parseFile(file);
        return new PythonVisitorContext.Builder(rootTree, file).workingDirectory(workingDirectory).packageName(packageName).projectLevelSymbolTable(projectLevelSymbolTable).cacheContext(cacheContext).build();
    }

    public static PythonVisitorContext createNotebookContext(File file, Map<Integer, IPythonLocation> locations, String content, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable, CacheContext cacheContext) {
        TestPythonFile pythonFile = new TestPythonFile(file);
        FileInput rootTree = TestPythonVisitorRunner.parseNotebookFile(locations, content);
        return new PythonVisitorContext.Builder(rootTree, pythonFile).packageName(packageName).projectLevelSymbolTable(projectLevelSymbolTable).cacheContext(cacheContext).build();
    }

    public static ProjectLevelSymbolTable globalSymbols(List<File> files, File baseDir) {
        ProjectLevelSymbolTable projectLevelSymbolTable = ProjectLevelSymbolTable.empty();
        for (File file : files) {
            TestPythonFile pythonFile = new TestPythonFile(file);
            String packageName = SymbolUtils.pythonPackageName(file, baseDir.getAbsolutePath());
            TestPythonVisitorRunner.fillSymbolTableWithFile(pythonFile, projectLevelSymbolTable, packageName);
        }
        return projectLevelSymbolTable;
    }

    public static ProjectLevelSymbolTable globalSymbols(Map<String, String> pathToContent, String baseDir) {
        ProjectLevelSymbolTable projectLevelSymbolTable = ProjectLevelSymbolTable.empty();
        pathToContent.forEach((path, content) -> {
            MockPythonFile file = new MockPythonFile(baseDir, (String)path, (String)content);
            String packageName = SymbolUtils.pythonPackageName(file.file(), baseDir);
            TestPythonVisitorRunner.fillSymbolTableWithFile(file, projectLevelSymbolTable, packageName);
        });
        return projectLevelSymbolTable;
    }

    private static void fillSymbolTableWithFile(TestablePythonFile file, ProjectLevelSymbolTable projectLevelSymbolTable, String packageName) {
        if (file.isIPython()) {
            return;
        }
        FileInput astRoot = TestPythonVisitorRunner.parseFile(file);
        projectLevelSymbolTable.addModule(astRoot, packageName, file);
    }

    public static FileInput parseNotebookFile(Map<Integer, IPythonLocation> locations, String content) {
        PythonParser parser = PythonParser.createIPythonParser();
        IPythonTreeMaker treeMaker = new IPythonTreeMaker(locations);
        AstNode astNode = parser.parse(content);
        return treeMaker.fileInput(astNode);
    }

    private static FileInput parseFile(TestablePythonFile file) {
        PythonParser parser = file.isIPython() ? PythonParser.createIPythonParser() : PythonParser.create();
        PythonTreeMaker treeMaker = file.isIPython() ? new IPythonTreeMaker(Map.of()) : new PythonTreeMaker();
        AstNode astNode = parser.parse(file.content());
        return treeMaker.fileInput(astNode);
    }

    private static class TestPythonFile
    implements TestablePythonFile {
        private final File file;

        public TestPythonFile(File file) {
            this.file = file;
        }

        @Override
        public String content() {
            try {
                return new String(Files.readAllBytes(this.file.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read " + this.file, e);
            }
        }

        @Override
        public String fileName() {
            return this.file.getName();
        }

        @Override
        public URI uri() {
            return this.file.toURI();
        }

        @Override
        public String key() {
            return this.file.getPath();
        }
    }

    static interface TestablePythonFile
    extends PythonFile {
        default public boolean isIPython() {
            return this.fileName().endsWith(".ipynb");
        }
    }

    public static class MockPythonFile
    implements TestablePythonFile {
        private final String baseDir;
        private final String path;
        private final String content;

        public MockPythonFile(String baseDir, String path, String content) {
            this.baseDir = baseDir;
            this.path = path;
            this.content = content;
        }

        @Override
        public String content() {
            return this.content;
        }

        @Override
        public String fileName() {
            File file = new File(this.path);
            return file.getName();
        }

        @Override
        public URI uri() {
            return new File(this.baseDir, this.path).toURI();
        }

        @Override
        public String key() {
            return this.path;
        }

        public File file() {
            return new File(this.baseDir, this.path);
        }
    }
}

