/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.nosonar;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.python.api.nosonar.NoSonarInfoParser;
import org.sonar.plugins.python.api.nosonar.NoSonarLineInfo;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class NoSonarLineInfoCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NoSonarLineInfoCollector.class);
    private final NoSonarInfoParser parser = new NoSonarInfoParser();
    private final Map<String, Map<Integer, NoSonarLineInfo>> componentKeyToNoSonarLineInfoMap = new ConcurrentHashMap<String, Map<Integer, NoSonarLineInfo>>();

    public void collect(String componentKey, @Nullable FileInput fileInput) {
        if (fileInput == null) {
            return;
        }
        Map<Integer, NoSonarLineInfo> result = this.scan(fileInput);
        if (!result.isEmpty()) {
            LOG.debug("File with key: {} has {} NOSONAR comments: {}", new Object[]{componentKey, result.size(), result});
            this.componentKeyToNoSonarLineInfoMap.put(componentKey, result);
        }
    }

    public Map<Integer, NoSonarLineInfo> get(String key) {
        return this.componentKeyToNoSonarLineInfoMap.getOrDefault(key, new ConcurrentHashMap());
    }

    public Set<Integer> getLinesWithEmptyNoSonar(String key) {
        return this.get(key).entrySet().stream().filter(entry -> ((NoSonarLineInfo)entry.getValue()).isSuppressedRuleKeysEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Map<Integer, NoSonarLineInfo> scan(Tree element) {
        ConcurrentHashMap<Integer, NoSonarLineInfo> result = new ConcurrentHashMap<Integer, NoSonarLineInfo>();
        ArrayDeque<Tree> stack = new ArrayDeque<Tree>();
        stack.push(element);
        while (!stack.isEmpty()) {
            Tree currentElement = (Tree)stack.pop();
            if (currentElement instanceof Token) {
                Token token = (Token)currentElement;
                Map<Integer, NoSonarLineInfo> tokenResults = this.visitToken(token);
                result.putAll(tokenResults);
            }
            currentElement.children().stream().filter(Objects::nonNull).forEach(stack::push);
        }
        return result;
    }

    private Map<Integer, NoSonarLineInfo> visitToken(Token token) {
        HashMap<Integer, NoSonarLineInfo> result = new HashMap<Integer, NoSonarLineInfo>();
        for (Trivia trivia : token.trivia()) {
            this.parseComment(trivia).ifPresent(info -> {
                int commentLine = trivia.token().line();
                NoSonarLineInfoCollector.calculateLines(commentLine, token).forEach(line -> result.put((Integer)line, (NoSonarLineInfo)info));
            });
        }
        return result;
    }

    private Optional<NoSonarLineInfo> parseComment(Trivia trivia) {
        String commentString = NoSonarLineInfoCollector.getContents(trivia.token().value());
        return this.parser.parse(commentString);
    }

    private static String getContents(String comment) {
        return comment.substring(comment.indexOf(35));
    }

    private static Set<Integer> calculateLines(int commentLine, Token parentToken) {
        ExpressionStatement expressionStatement;
        HashSet<Integer> lines = new HashSet<Integer>();
        lines.add(commentLine);
        Tree tree = parentToken.parent();
        if (tree instanceof ExpressionStatement && !(expressionStatement = (ExpressionStatement)tree).expressions().isEmpty() && (tree = expressionStatement.expressions().get(0)) instanceof StringLiteral) {
            int firstLine;
            StringLiteral stringLiteral = (StringLiteral)tree;
            for (int i = firstLine = stringLiteral.firstToken().line(); i < commentLine + 1; ++i) {
                lines.add(i);
            }
        }
        return lines;
    }

    public String getSuppressedRuleIds() {
        return this.componentKeyToNoSonarLineInfoMap.values().stream().flatMap(map -> map.values().stream()).flatMap(noSonarLineInfo -> noSonarLineInfo.suppressedRuleKeys().stream()).distinct().sorted().collect(Collectors.joining(","));
    }

    public String getCommentWithExactlyOneRuleSuppressed() {
        return this.componentKeyToNoSonarLineInfoMap.values().stream().flatMap(map -> map.values().stream()).filter(noSonarLineInfo -> noSonarLineInfo.suppressedRuleKeys().size() == 1).map(noSonarLineInfo -> (String)noSonarLineInfo.suppressedRuleKeys().stream().findFirst().get() + ":" + noSonarLineInfo.comment()).collect(Collectors.joining(";;"));
    }
}

