/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.dependency;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.python.dependency.model.Dependencies;
import org.sonar.plugins.python.dependency.model.Dependency;

public class RequirementsTxtParser {
    private static final Logger LOG = LoggerFactory.getLogger(RequirementsTxtParser.class);

    private RequirementsTxtParser() {
    }

    public static Dependencies parseRequirementFile(InputFile requirementFile) {
        HashSet<Dependency> dependencySet = new HashSet<Dependency>();
        String fileContent = "";
        try {
            fileContent = requirementFile.contents();
        }
        catch (IOException e) {
            LOG.warn("There was an exception when parsing {}. No dependencies were extracted.", (Object)requirementFile.filename(), (Object)e);
            return new Dependencies(Set.of());
        }
        for (String line : fileContent.lines().toList()) {
            String[] splittedLine;
            if ((line = line.strip()).isEmpty() || line.startsWith("#") || line.startsWith("-") || (splittedLine = line.split("\\s+")).length < 1 || !splittedLine[0].toUpperCase(Locale.ENGLISH).matches("^([A-Z0-9]|[A-Z0-9][A-Z0-9._-]*[A-Z0-9])$")) continue;
            dependencySet.add(new Dependency(splittedLine[0]));
        }
        return new Dependencies(dependencySet);
    }
}

