/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.dependency;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.python.dependency.model.Dependencies;
import org.sonar.plugins.python.dependency.model.Dependency;

public class PyProjectTomlParser {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z0-9-_.]+");

    private PyProjectTomlParser() {
    }

    public static Dependencies parse(InputFile inputFile) {
        try {
            PyProjectToml pyProjectToml = PyProjectTomlParser.readPyProjectToml(inputFile);
            return PyProjectTomlParser.convertToDependenciesModel(pyProjectToml);
        }
        catch (IOException e) {
            return new Dependencies(Set.of());
        }
    }

    private static PyProjectToml readPyProjectToml(InputFile inputFile) throws IOException {
        return new TomlMapper().registerModule(new Jdk8Module()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(inputFile.contents(), PyProjectToml.class);
    }

    private static Dependencies convertToDependenciesModel(PyProjectToml pyProjectToml) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        dependencies.addAll(PyProjectTomlParser.collectProjectDependencies(pyProjectToml));
        dependencies.addAll(PyProjectTomlParser.collectPoetryDependencies(pyProjectToml));
        return new Dependencies(dependencies);
    }

    private static Set<Dependency> collectProjectDependencies(PyProjectToml pyProjectToml) {
        if (pyProjectToml.project() != null) {
            return pyProjectToml.project().dependencies().stream().flatMap(PyProjectTomlParser::parseDependency).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private static Set<Dependency> collectPoetryDependencies(PyProjectToml pyProjectToml) {
        if (pyProjectToml.tool() != null && pyProjectToml.tool().poetry() != null) {
            return pyProjectToml.tool().poetry().dependencies().keySet().stream().flatMap(PyProjectTomlParser::parseDependency).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private static Stream<Dependency> parseDependency(String dependency) {
        Matcher matcher = IDENTIFIER_PATTERN.matcher(dependency);
        if (matcher.find()) {
            return Stream.of(new Dependency(matcher.group()));
        }
        return Stream.empty();
    }

    private record PyProjectToml(@Nullable Project project, @Nullable Tool tool) {
    }

    private record Project(@Nonnull @JsonSetter(nulls=Nulls.AS_EMPTY) List<String> dependencies) {
    }

    private record Tool(@Nullable Poetry poetry) {
    }

    private record Poetry(@Nonnull @JsonSetter(nulls=Nulls.AS_EMPTY) Map<String, String> dependencies) {
    }
}

