/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.types.v2;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.types.v2.PythonType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public interface UnknownType
extends PythonType {
    @Override
    default public boolean isCompatibleWith(PythonType another) {
        return true;
    }

    public record UnresolvedImportType(String importPath) implements UnknownType
    {
        @Override
        public Optional<PythonType> resolveMember(String memberName) {
            String memberFqn = Stream.of(this.importPath, memberName).filter(Predicate.not(String::isEmpty)).collect(Collectors.joining("."));
            return Optional.of(new UnresolvedImportType(memberFqn));
        }
    }

    public static final class UnknownTypeImpl
    implements UnknownType {
        UnknownTypeImpl() {
        }
    }
}

