/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.types.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.python.types.v2.LazyType;

@Beta
public class UnionType
implements PythonType {
    private final Set<PythonType> candidates = new HashSet<PythonType>();

    private UnionType(Set<PythonType> candidates) {
        this.candidates.addAll(candidates);
    }

    public Set<PythonType> candidates() {
        return this.candidates;
    }

    @Override
    public Optional<String> displayName() {
        ArrayList candidateNames = new ArrayList();
        for (PythonType candidate : this.candidates) {
            Optional<String> s = candidate.displayName();
            s.ifPresent(candidateNames::add);
            if (!s.isEmpty()) continue;
            return Optional.empty();
        }
        String name = candidateNames.stream().sorted().collect(Collectors.joining(", ", "Union[", "]"));
        return Optional.of(name);
    }

    @Override
    public TriBool hasMember(String memberName) {
        Set uniqueResult = this.candidates.stream().map(c -> c.hasMember(memberName)).collect(Collectors.toSet());
        return uniqueResult.size() == 1 ? (TriBool)((Object)uniqueResult.iterator().next()) : TriBool.UNKNOWN;
    }

    @Override
    public boolean isCompatibleWith(PythonType another) {
        return this.candidates.isEmpty() || this.candidates.stream().anyMatch(candidate -> candidate.isCompatibleWith(another));
    }

    @Override
    public TypeSource typeSource() {
        return this.candidates.stream().map(PythonType::typeSource).min(Comparator.comparing(TypeSource::score)).orElse(TypeSource.EXACT);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionType unionType = (UnionType)o;
        return Objects.equals(this.candidates, unionType.candidates);
    }

    public int hashCode() {
        return Objects.hashCode(this.candidates);
    }

    public String toString() {
        return this.displayName().orElse(super.toString());
    }

    public static PythonType or(@Nullable PythonType type1, @Nullable PythonType type2, PythonType ... types) {
        if (types == null) {
            types = new PythonType[]{};
        }
        HashSet<PythonType> typeSet = new HashSet<PythonType>();
        typeSet.add(type1);
        typeSet.add(type2);
        typeSet.addAll(Set.of(types));
        return UnionType.or(typeSet);
    }

    public static PythonType or(Collection<PythonType> types) {
        if ((types = (Collection)types.stream().filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty()) {
            return PythonType.UNKNOWN;
        }
        if (types.size() == 1) {
            return (PythonType)types.iterator().next();
        }
        Set<PythonType> flatTypes = types.stream().flatMap(UnionType::flattenPythonType).collect(Collectors.toSet());
        if (flatTypes.stream().anyMatch(type -> type == PythonType.UNKNOWN)) {
            return PythonType.UNKNOWN;
        }
        UnionType.ensureCandidatesAreNotLazyTypes(flatTypes);
        return new UnionType(flatTypes);
    }

    private static Stream<PythonType> flattenPythonType(PythonType type) {
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            return unionType.candidates().stream();
        }
        return Stream.of(type);
    }

    private static void ensureCandidatesAreNotLazyTypes(Collection<PythonType> types) {
        if (types.stream().anyMatch(LazyType.class::isInstance)) {
            throw new IllegalArgumentException("UnionType cannot contain Lazy types");
        }
    }
}

