/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.types.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.Member;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;

@Beta
public final class ObjectType
implements PythonType {
    private final TypeWrapper typeWrapper;
    private final List<PythonType> attributes;
    private final List<Member> members;
    private final TypeSource typeSource;

    public ObjectType(TypeWrapper typeWrapper, List<PythonType> attributes, List<Member> members, TypeSource typeSource) {
        this.typeWrapper = typeWrapper;
        this.attributes = attributes;
        this.members = members;
        this.typeSource = typeSource;
    }

    public ObjectType(PythonType type, List<PythonType> attributes, List<Member> members, TypeSource typeSource) {
        this(TypeWrapper.of(type), attributes, members, typeSource);
    }

    public ObjectType(PythonType type) {
        this(type, TypeSource.EXACT);
    }

    public ObjectType(TypeWrapper typeWrapper) {
        this(typeWrapper, new ArrayList<PythonType>(), new ArrayList<Member>(), TypeSource.EXACT);
    }

    public ObjectType(PythonType type, TypeSource typeSource) {
        this(type, new ArrayList<PythonType>(), new ArrayList<Member>(), typeSource);
    }

    public ObjectType(PythonType type, List<PythonType> attributes, List<Member> members) {
        this(type, attributes, members, TypeSource.EXACT);
    }

    @Override
    public Optional<String> displayName() {
        return this.typeWrapper.type().instanceDisplayName();
    }

    @Override
    public boolean isCompatibleWith(PythonType another) {
        return this.typeWrapper.type().isCompatibleWith(another);
    }

    @Override
    public PythonType unwrappedType() {
        return this.typeWrapper.type();
    }

    @Override
    public Optional<PythonType> resolveMember(String memberName) {
        return this.members().stream().filter(member -> Objects.equals(member.name(), memberName)).map(Member::type).findFirst().or(() -> this.typeWrapper.type().resolveMember(memberName));
    }

    @Override
    public TriBool hasMember(String memberName) {
        if (this.resolveMember(memberName).isPresent()) {
            return TriBool.TRUE;
        }
        PythonType pythonType = this.typeWrapper.type();
        if (pythonType instanceof ClassType) {
            ClassType classType = (ClassType)pythonType;
            return classType.instancesHaveMember(memberName);
        }
        return TriBool.UNKNOWN;
    }

    @Override
    public Optional<LocationInFile> definitionLocation() {
        return this.typeWrapper.type().definitionLocation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        List<String> membersNames = this.members.stream().map(Member::name).toList();
        List<String> otherMembersNames = that.members.stream().map(Member::name).toList();
        List<String> attributesNames = this.attributes.stream().map(PythonType::key).toList();
        List<String> otherAttributesNames = that.attributes.stream().map(PythonType::key).toList();
        return Objects.equals(this.typeWrapper, that.typeWrapper) && Objects.equals(membersNames, otherMembersNames) && Objects.equals(attributesNames, otherAttributesNames);
    }

    public int hashCode() {
        List<String> membersNames = this.members.stream().map(Member::name).toList();
        List<String> attributesNames = this.attributes.stream().map(PythonType::key).toList();
        return Objects.hash(this.typeWrapper, attributesNames, membersNames);
    }

    public PythonType type() {
        return this.typeWrapper.type();
    }

    public TypeWrapper typeWrapper() {
        return this.typeWrapper;
    }

    public List<PythonType> attributes() {
        return this.attributes;
    }

    public List<Member> members() {
        return this.members;
    }

    @Override
    public TypeSource typeSource() {
        return this.typeSource;
    }

    public String toString() {
        return "ObjectType[type=" + this.typeWrapper + ", attributes=" + this.attributes + ", members=" + this.members + ", typeSource=" + this.typeSource + "]";
    }
}

