/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.types.v2;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;

@Beta
public final class ModuleType
implements PythonType {
    private final String name;
    private final String fullyQualifiedName;
    private final ModuleType parent;
    private final Map<String, TypeWrapper> members;
    private final Map<String, TypeWrapper> subModules;

    public ModuleType(@Nullable String name, @Nullable String fullyQualifiedName, @Nullable ModuleType parent, Map<String, TypeWrapper> members) {
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.parent = parent;
        this.members = members;
        this.subModules = new ConcurrentHashMap<String, TypeWrapper>();
        this.registerAsSubmoduleOfParent(parent);
    }

    private void registerAsSubmoduleOfParent(@Nullable ModuleType parent) {
        if (parent == null) {
            return;
        }
        parent.subModules.putIfAbsent(this.name, TypeWrapper.of(this));
    }

    public ModuleType(@Nullable String name) {
        this(name, null);
    }

    public ModuleType(@Nullable String name, @Nullable ModuleType parent) {
        this(name, null, parent, new HashMap<String, TypeWrapper>());
    }

    public ModuleType(@Nullable String name, @Nullable ModuleType parent, Map<String, TypeWrapper> members) {
        this(name, null, parent, members);
    }

    @Override
    public Optional<PythonType> resolveMember(String memberName) {
        return Optional.ofNullable(this.members.get(memberName)).map(TypeWrapper::type).or(() -> this.resolveSubmodule(memberName));
    }

    public Optional<PythonType> resolveSubmodule(String submoduleName) {
        return Optional.ofNullable(this.subModules.get(submoduleName)).map(TypeWrapper::type);
    }

    @Override
    public TriBool hasMember(String memberName) {
        if (this.resolveMember(memberName).isPresent()) {
            return TriBool.TRUE;
        }
        return TriBool.UNKNOWN;
    }

    public String toString() {
        return "ModuleType{name='" + this.name + "', members=" + this.members + "}";
    }

    @Override
    @CheckForNull
    public String name() {
        return this.name;
    }

    @CheckForNull
    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @CheckForNull
    public ModuleType parent() {
        return this.parent;
    }

    public Map<String, TypeWrapper> members() {
        return this.members;
    }
}

