/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.types.v2;

import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.types.v2.ParameterV2;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeOrigin;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;

@Beta
public final class FunctionType
implements PythonType {
    private final String name;
    private final String fullyQualifiedName;
    private final List<PythonType> attributes;
    private final List<ParameterV2> parameters;
    private final List<TypeWrapper> decorators;
    private TypeWrapper returnType;
    private final TypeOrigin typeOrigin;
    private final boolean isAsynchronous;
    private final boolean hasDecorators;
    private final boolean isInstanceMethod;
    private final boolean hasVariadicParameter;
    private final PythonType owner;
    private final LocationInFile locationInFile;

    public FunctionType(String name, String fullyQualifiedName, List<PythonType> attributes, List<ParameterV2> parameters, List<TypeWrapper> decorators, TypeWrapper returnType, TypeOrigin typeOrigin, boolean isAsynchronous, boolean hasDecorators, boolean isInstanceMethod, boolean hasVariadicParameter, @Nullable PythonType owner, @Nullable LocationInFile locationInFile) {
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.attributes = attributes;
        this.parameters = parameters;
        this.decorators = decorators;
        this.returnType = returnType;
        this.typeOrigin = typeOrigin;
        this.isAsynchronous = isAsynchronous;
        this.hasDecorators = hasDecorators;
        this.isInstanceMethod = isInstanceMethod;
        this.hasVariadicParameter = hasVariadicParameter;
        this.owner = owner;
        this.locationInFile = locationInFile;
    }

    @Override
    public Optional<String> displayName() {
        return Optional.of("Callable");
    }

    @Override
    public Optional<LocationInFile> definitionLocation() {
        return Optional.ofNullable(this.locationInFile);
    }

    public String toString() {
        return "FunctionType[%s]".formatted(this.name);
    }

    @Override
    public String name() {
        return this.name;
    }

    public List<PythonType> attributes() {
        return this.attributes;
    }

    public List<ParameterV2> parameters() {
        return this.parameters;
    }

    public PythonType returnType() {
        return this.returnType.type();
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    public List<TypeWrapper> decorators() {
        return this.decorators;
    }

    public boolean isInstanceMethod() {
        return this.isInstanceMethod;
    }

    public boolean hasVariadicParameter() {
        return this.hasVariadicParameter;
    }

    @CheckForNull
    public PythonType owner() {
        return this.owner;
    }

    public TypeOrigin typeOrigin() {
        return this.typeOrigin;
    }

    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }
}

