/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.types.v2;

import java.util.Optional;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.types.v2.SpecialFormType;

@Beta
public class FullyQualifiedNameHelper {
    private FullyQualifiedNameHelper() {
    }

    @Beta
    public static Optional<String> getFullyQualifiedName(PythonType type) {
        if (type instanceof FunctionType) {
            FunctionType functionType = (FunctionType)type;
            return Optional.ofNullable(functionType.fullyQualifiedName());
        }
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            return Optional.ofNullable(classType.fullyQualifiedName());
        }
        if (type instanceof ModuleType) {
            ModuleType moduleType = (ModuleType)type;
            return Optional.ofNullable(moduleType.fullyQualifiedName());
        }
        if (type instanceof SpecialFormType) {
            SpecialFormType specialFormType = (SpecialFormType)type;
            return Optional.ofNullable(specialFormType.fullyQualifiedName());
        }
        if (type instanceof UnknownType.UnresolvedImportType) {
            UnknownType.UnresolvedImportType unresolvedImportType = (UnknownType.UnresolvedImportType)type;
            return Optional.ofNullable(unresolvedImportType.importPath());
        }
        return Optional.empty();
    }
}

